let loading_update = "loading-update";
let brand_name = "brand_name";
let link_brand = "link_brand";
let upload_image = "upload_image";
let form_submit_product_brand = "form-data-product-brand";

$('#daterange').daterangepicker({
    autoUpdateInput: false,
    "format": 'Y-m-d H:i:s',
    "startDate": moment().subtract(29, 'days').format('YYYY/MM/DD'),
    "endDate": moment().format('YYYY/MM/DD'),
    "opens": "center",
    "showDropdowns": true,
    locale: {
      format: 'YYYY/MM/DD'
    },
}, function(start, end, label) {
$("#daterange").val(start.format('YYYY/MM/DD')+" - "+end.format('YYYY/MM/DD'));
  table.draw();
  //var this.start_date = start.format('YYYY-MM-DD')?start.format('YYYY-MM-DD'):'sas';
  //console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
});

$('#daterange').on('apply.daterangepicker', function(ev, picker) {
    $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    table.draw();
});

$('#daterange').on('cancel.daterangepicker', function(ev, picker) {
    $(this).val('');
    table.draw();
});


var columnsDataTable = [

    { data: 'name_brand', className: 'mobile tablet desktop' },/**[0]*/
    { data: 'image_brand'},/**[1]*/
    { data: 'uri_brand'},/**[2]*/
    { data: 'url_brand'},/**[3]*/
    { data: 'name_user', className: ' tablet desktop'},/**[4]*/
    { data: 'name_user', className: ' tablet desktop'},/**[5]*/
    { data: 'created_brand', className: ' tablet desktop'},/**[6]*/
    { data : 'updated_brand', className: ' tablet desktop'},/**[7]*/
    { data: 'status_brand', className: 'editor-status tablet desktop'},/**[8]*/
    { data: null, className: 'editor-edit-act mobile tablet desktop'},/**[9]*/

];

var columnDefsDataTable = [
    {
       targets: 1,
       render: function (data, type, row) {
            if(data!=null){
                return "<img style='width:150px !important;' src='"+baseUrlApi+"/writable/uploads/"+data+"' />";
            }else{
                return "<img style='width:150px !important;' src='"+baseUrlApi+"/assets/img/main_banner/noimage.png' />";
                
            }
       },

    },{

        targets:6,

        render:function(data,type,row){
            if(data){
                return moment(data).format('YYYY-MM-DD');
            }else{
                return '<p style="color: #cecece !important;">NULL</p>';
            }
        }
    },{
        targets:7,

        render:function(data,type,row){
            if(data){
                return moment(data).format('YYYY-MM-DD');
            }else{
                return '<p style="color: #cecece !important;">NULL</p>';
            }
        }
    },{
        targets:8,

        data: null,
        className: "editor-edit-mc",
        render: function (data, type, row) {

            if(data==1){
                return  '<div class="form-check form-switch">'+

                            '<input class="form-check-input" name="checkbox" data-id="'+btoa(row.key_brand)+'" value="0" type="checkbox" role="switch" id="flexSwitchCheckChecked" checked>'+
                        '</div>';
            }else{
                return '<div class="form-check form-switch">'+
                            '<input class="form-check-input" name="checkbox" data-id="'+btoa(row.key_brand)+'" value="1" type="checkbox" role="switch" id="flexSwitchCheckDefault">'+

                        '</div>';
            }
        },

    },{

        targets:9,

        data: null,
        className: "editor-edit-mc",
        render: function (data, type, row) {

            return '<div class="row">'+
                    '<div class="col-md-3">'+
                        '<button id="edit-data" class=" btn btn-warning " style="font-size:12px; padding:1px 3px; color:#fff;"><i class="fas fa-edit"></i> </button>'+
                    '</div>'+
                    '<div class="col-md-3">'+
                        '<button class=" btn btn-danger " style="font-size:12px; padding:1px 3px;"><i class="fas fa-trash"></i> </button>'+
                    '</div>'+
                '</div>';
        },

    },

   
];
var buttonsActionTopTable = [
    {
        extend: 'csv',
        text: '<i class="fas fa-file-export"></i> Export CSV',
        className: 'MBottom15 btn-space btn btn-warning fontSz12',
        exportOptions: {
            orthogonal: null
        }
    },{
        text: '<i class="fas fa-paper-plane"></i> Approve',
        className: 'MBottom15 btn btn-success fontSz12 btn-approval',
        action: function () {
            tableDetailsApprove.clear();
            var dataTable = $('#dataTable').DataTable();    
                
            
            $('#ModalDataTableDetailsApprove').modal('show');
            tableDetailsApprove.draw();

            $('#ModalDataTableDetailsApprove').on('click', '#yes-approve', function (e) { 
                var params = e.target.dataset.id;
                $("#key_approval_vh__").val(params);
                $("#ModalDataTableDetailsApprove").modal('hide');
                $("#dataTableConfirmApprove").modal('show');
                
            }); 
        }
    },
];

var table = $('#dataTable').DataTable({
    processing      : true,
    serverSide      : true,
    responsive      : true,
    paging          : true,
    "orderable": true,
    buttons: buttonsActionTopTable,
    ajax:{
        method:'POST',
        url: baseUrlApi+'/admin/product-brand/list-data',
        pages: 5, // number of pages to cache
        data: function ( d ) {
            
            return $.extend( {}, d, {
            "filter_daterange": $("#daterange").val()
            //"uri_segment": uri_segment ? uri_segment :'',
            } );
            
        },
        error: function(){
            
        },

      
    },
    'fnCreatedRow': function (nRow, aData, iDataIndex) {

        $(nRow).attr('data-id', btoa(aData.key_brand));

    },
    columns: columnsDataTable,
    columnDefs: columnDefsDataTable
});

// $('input').keyup(function() {
//     table.clear().draw();
//     console.log("After No. of rows: ", table.row().count());
// } );
// $form.append('<input type="button" value="button">');  
var isValid = $("#"+form_submit_product_brand).validate({
    errorClass: "is-invalid",
    rules:{
        brand_name:{
            required: true,
        },
        upload_image:{
            required: true,
        },
        link_brand:{
            required: true,
        },
    },
    messages: {
        
        brand_name: {
            required: '<p style="color:#e74a3b; font-size:16px;">Field "Brand Name" is required</p>',
        },
        upload_image:{
            required: '<p style="color:#e74a3b; font-size:16px;">Field "Upload Image Brand" is required</p>',
        },
        link_brand:{
            required: '<p style="color:#e74a3b; font-size:16px;">Field "Link brand" is required</p>',
        }
    },
    errorPlacement: function(error, element) 
    {
        if ( element.is(":radio") ) 
        {
            error.appendTo( element.parents('.container') );
        }
        else 
        { // This is the default behavior 
            error.insertAfter( element );
        }
    }
});


//PROCESS CANCEL
$('#'+form_submit_product_brand).on( 'click', '#cancel_vh', function (e) {
    if(typeof $("#type-post").val() !== "undefined"){
        $("#AddDataCollapse>.card-body").removeClass('qq-box-shadow-green');
        $('#type-post').remove();

        $('#key-brand').remove();

        $("#image-mb").remove();
        $( "#upload_image" ).rules( "add", "required" );
    }
    $("#close-main-banner").remove();
    $("#"+upload_image).val("");
    
    var file = baseUrlApi+"/assets/img/noimage.png";
    if (file){
    
        $('#preview-main-banner').attr('src', file);
        
    }
});

// PROCESS  UPDATE STATUS (SWITCH ON/OF) 
$('#dataTable').on( 'change', '.editor-status [name=checkbox]', function (e) {
    $(this).toggleClass('deselected');
    $("#remove-all").addClass("qq-btn-remove-inactive");
    $("#remove-all").attr("id","remove-all-none");
    // Edit the value, but this selector allows clicking on label as well
    //console.log($(e.target).val()); return false;
    if(confirm("do you want to update main banner status?")){
        $.ajax({
            type: 'POST',
            url: baseUrlApi+'/admin/product-brand/update-data',
            data: JSON.stringify({'status':$(e.target).val(), "id":atob($(this).data('id'))}),
            dataType: 'json',
            contentType: 'application/json',
            cache: false,
            processData:false,
            beforeSend: function(){
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");
                $("#err_message_import").html('');
                $("#"+loading_update).css({'display':'block','padding-top':'50%'});
            },
            success: function(response){
                if(response.err_code==200){
                    // $("[name="+category+"]").val('');
                    // $("[name="+icon_category+"]").val('');
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'!</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    table.draw();
                    // $('html, body').animate({
                    //     scrollTop: $("table").offset().top
                    // },700);
                }else{
                    $("#err_message_import").html('');
                    //elm_username.value = response.resp_data;
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                }
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $("#"+loading_update).css('display','none');


            },
            timeout: 3000

        });
    }else{
        table.draw();
    }
    
} );

// PROCCESS EDIT ONE ROW DATA 
$('#dataTable').on( 'click', '.editor-edit-act #edit-data', function (e) {
    
    $( "#upload_image" ).rules( "remove", "required" );
    $("#remove-all").addClass("qq-btn-remove-inactive");
    $("#remove-all").attr("id","remove-all-none");
    table.draw();
    //console.log(atob($(this).parents('tr').data('id'))); return false;
    // Edit the value, but this selector allows clicking on label as well
    //console.log($(e.target).val()); return false;
    if(confirm("are you sure to edit data?")){
        $.ajax({
            type: 'POST',
            url: baseUrlApi+'/admin/product-brand/list-data-single',
            data: JSON.stringify({"id":atob($(this).parents('tr').data('id'))}),
            dataType: 'json',
            contentType: 'application/json',
            cache: false,
            processData:false,
            beforeSend: function(){
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");

                $("#key-brand").remove();

                $("#image-mb").remove();
                $("#type-post").remove();
                // $("#err_message_import").html('');
                $("#"+loading_update).css({'display':'block','padding-top':'50%'});
            },
            success: function(response){
                

                //console.log(response.data.image_brand.split("/")[1]); return false;
                if(response.err_code==200){
                    $("[name="+brand_name+"]").val(response.data.name_brand);
                    $("[name="+link_brand+"]").val(response.data.url_brand);
                    if(response.data.image_brand){

                        var icons_close = document.createElement("i");
                        $(icons_close).attr('id', 'close-main-banner');
                        $(icons_close).addClass("fas fa-window-close text-danger");
                        $(".qq-form-file-img").append(icons_close);
                    }

                    $('#preview-main-banner').attr('src', baseUrlApi+'/writable/uploads/'+response.data.image_brand);


                    $('<input>').attr({
                        type: 'hidden',
                        id: 'image-mb',
                        name: 'last_upload_image',

                        value: response.data.image_brand,
                    }).appendTo('#form-data-product-brand').insertBefore( "#submit_vh" );
                    $('<input>').attr({
                        type: 'hidden',
                        id: 'key-brand',
                        name: 'key_brand',
                        value: response.data.key_brand,
                    }).appendTo('#form-data-product-brand').insertBefore( "#submit_vh" );

                    $('<input>').attr({
                        type: 'hidden',
                        id: 'type-post',
                        name: 'type_post',
                        value: 'update',

                    }).appendTo('#form-data-product-brand').insertBefore( "#submit_vh" );

                    //console.log(response.data); return false;
                    $("#AddDataCollapse>.card-body").addClass('qq-box-shadow-green');
                    
                    table.draw();
                    $('html, body').animate({
                        scrollTop: $("table").offset().top
                    },100);
                }else{
                    $("#err_message_import").html('');
                    //elm_username.value = response.resp_data;
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                }
                $('html, body').animate({
                    scrollTop: $("#qq-top-form").offset().top
                },700);
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $("#"+loading_update).css('display','none');


            },
            timeout: 3000

        });
    }else{
        table.draw();
    }
    
} );

// PROCESS SELECTED ROW DATA/TABLE
$('#dataTable tbody').on('click', 'tr', function (e) {
    $(this).toggleClass('selected');
    if(table.rows('.selected').data().length>0){
        $("#remove-all-none").removeClass("qq-btn-remove-inactive");
        $("#remove-all-none").attr("id","remove-all");
    }else{
        $("#remove-all").addClass("qq-btn-remove-inactive");
        $("#remove-all").attr("id","remove-all-none");
    }
});

// PROCESS REMOVE DATA SELECTED
$('.table-responsive').on( 'click', '#remove-all', function (e) {
    //alert(table.rows('.selected').data().length + ' row(s) selected');
    $("#remove-all").addClass("qq-btn-remove-inactive");
    $("#remove-all").attr("id","remove-all-none");
    //console.log(table.rows('.selected').data());
    //const element = '';
    var element = {};
    for (var index = 0; index < table.rows('.selected').data().length; index++) {

     element[index] = table.rows('.selected').data()[index].key_brand;

        
    }
    const result = Object.values(element).map(value => {
        //console.log(value); // 👉️ 4, 8
      
        return  {"id":value};
      });

      if(confirm("are you sure to delete data selected?")){
        $.ajax({
            type: 'POST',
            url: baseUrlApi+'/admin/product-brand/remove-data-selected',
            data: JSON.stringify(result),
            dataType: 'json',
            contentType: 'application/json',
            cache: false,
            processData:false,
            beforeSend: function(){
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");
                $("#err_message_import").html('');
                $("#"+loading_update).css({'display':'block','padding-top':'50%'});
            },
            success: function(response){
                if(response.err_code==200){
                    // $("[name="+category+"]").val('');
                    // $("[name="+icon_category+"]").val('');
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'!</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    table.draw();
                    $('html, body').animate({
                        scrollTop: $("table").offset().top
                    },700);
                }else{
                    $("#err_message_import").html('');
                    //elm_username.value = response.resp_data;
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                }
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $("#"+loading_update).css('display','none');


            },
            timeout: 3000

        });
    }else{
        table.draw();
    }
    //table.draw();
    
});

// PROCCESS REMOVE ONE ROW DATA
$('#dataTable').on( 'click', '.editor-edit-act .btn-danger', function (e) {
    $(this).toggleClass('deselected');
    $("#remove-all").addClass("qq-btn-remove-inactive");
    $("#remove-all").attr("id","remove-all-none");
    //console.log($(this).parents('tr').data('id'));return false;
    //console.log(atob()); return false;
    // Edit the value, but this selector allows clicking on label as well
    //console.log($(e.target).val()); return false;
    if(confirm("are you sure to delete data?")){
        $.ajax({
            type: 'POST',
            url: baseUrlApi+'/admin/product-brand/remove-data',
            data: JSON.stringify({"id":atob($(this).parents('tr').data('id'))}),
            dataType: 'json',
            contentType: 'application/json',
            cache: false,
            processData:false,
            beforeSend: function(){
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");
                $("#err_message_import").html('');
                $("#"+loading_update).css({'display':'block','padding-top':'50%'});
            },
            success: function(response){
                if(response.err_code==200){
                    // $("[name="+category+"]").val('');
                    // $("[name="+icon_category+"]").val('');
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'!</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    table.draw();
                    // $('html, body').animate({
                    //     scrollTop: $("table").offset().top
                    // },700);
                }else{
                    $("#err_message_import").html('');
                    //elm_username.value = response.resp_data;
                    $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                }
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $("#"+loading_update).css('display','none');

            },
            timeout: 3000

        });
    }else{
        table.draw();
    }
    
} );

// PROCESS INSERT & UPDATE 
$("#"+form_submit_product_brand).on('submit', function(e){
    // console.log($("form"));
    let url_insert_update = '';
   
    if(typeof $("#type-post").val() === "undefined"){
        url_insert_update = baseUrlApi+'/admin/product-brand/post-data';
        if(!isValid.valid()){
            return false;
        }
    }else{
        url_insert_update = baseUrlApi+'/admin/product-brand/update-data';
    }
    
    //console.log(); 
    //return false;
    //return false;
    e.preventDefault();
    $.ajax({
        type: 'POST',
        url: url_insert_update,
        data: new FormData(this),
        dataType: 'json',
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function(){
            // if(typeof $("#type-post").val() !== "undefined"){
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");
                $("#err_message_import").html('');
                $("#"+loading_update).css({'display':'block','padding-top':'0px'});
            // }else{

            // }
        },
        success: function(response){
            if(response.err_code==200){
                $( "#upload_image" ).rules( "add", "required" );
                if(typeof $("#type-post").val() !== "undefined"){
                    $("#AddDataCollapse>.card-body").removeClass('qq-box-shadow-green');
                    $('#type-post').remove();

                    $('#key-brand').remove();

                }
                $("#close-main-banner").remove();
                var file = baseUrlApi+"/assets/img/noimage.png";
                if (file){
                
                    $('#preview-main-banner').attr('src', file);
                    
                }
                $("#"+form_submit_product_brand)[0].reset()
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                table.draw();
                $('html, body').animate({
                    scrollTop: $("table").offset().top
                },700);
            }else{
                $("#err_message_import").html('');
                //elm_username.value = response.resp_data;
                $("#err_message_import").first().hide().fadeIn(200).delay(2000).fadeOut(1000, function () { });
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $("#"+loading_update).css('display','none');


        },
        timeout: 3000

    });
});

// Event preview main banner image
$('#'+upload_image).change(function(){
    $("#close-main-banner").remove();
    const file = this.files[0];
    console.log(file);
    var icons_close = document.createElement("i");
    $(icons_close).attr('id', 'close-main-banner');
    $(icons_close).addClass("fas fa-window-close text-danger");
    $(".qq-form-file-img").append(icons_close);
    
    if (file){
      let reader = new FileReader();
      reader.onload = function(event){
        //console.log(event.target.result);
        $('#preview-main-banner').attr('src', event.target.result);
      }
      reader.readAsDataURL(file);
    }
  
});
$(document).on('click', '#close-main-banner', function() {
    $("#close-main-banner").remove();
    $("#"+upload_image).val("");
    var file = baseUrlApi+"/assets/img/noimage.png";
    if (file){
       
        $('#preview-main-banner').attr('src', file);
        
      }
});


$('#close-main-banner').on( 'click', function(){
    alert("abah yeuh"); return false;
    const file = this.files[0];
    console.log(file);
    $(".qq-form-file-img").remove();
    if (file){
      let reader = new FileReader();
      reader.onload = function(event){
        console.log(event.target.result);
        $('#preview-main-banner').attr('src', event.target.result);
      }
      reader.readAsDataURL(file);
    }
});
// End preview main banner image

$(document).ready(function () {
    
    table.draw();
});