//
// Pipelining function for DataTables. To be used to the `ajax` option of DataTables
//


//
// DataTables initialisation
//
$('#daterange').daterangepicker({
    autoUpdateInput: false,
    "format": 'Y-m-d H:i:s',
    "startDate": moment().subtract(29, 'days').format('YYYY/MM/DD'),
    "endDate": moment().format('YYYY/MM/DD'),
    "opens": "center",
    "showDropdowns": true,
    locale: {
      format: 'YYYY/MM/DD'
    },
}, function(start, end, label) {
$("#daterange").val(start.format('YYYY/MM/DD')+" - "+end.format('YYYY/MM/DD'));
  table.draw();
  //var this.start_date = start.format('YYYY-MM-DD')?start.format('YYYY-MM-DD'):'sas';
  //console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
});
$('#daterange').on('apply.daterangepicker', function(ev, picker) {
    $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    table.draw();
});

$('#daterange').on('cancel.daterangepicker', function(ev, picker) {
    $(this).val('');
    table.draw();
});


var table = $('#dataTable').DataTable({
  processing: true,
  serverSide: true,
  /*scrollY         : true,
    scrollX         : true,
    scrollCollapse  : true,
    fixedColumns    :   {
        leftColumns     : 1,
        rightColumns    : 2
    },*/
  ajax:{
      method:'POST',
      url: baseUrlApi+'/data/palms/members',
      pages: 5, // number of pages to cache
      data: function ( d ) {
         return $.extend( {}, d, {
           "filter_daterange": $("#daterange").val(),
         } );
       },
      error: function(){  
      },

      
  },

  columns: [
      { data: 'full_name' },
      { data: 'first_name' },
      { data: 'last_name' },
      { data: 'contact_number' },
      { data: 'email' },
      { data: 'address' },
      { data: 'bisnis_description' },
      { data: 'group_name' },
      null
  ],
  columnDefs: [
    {
       targets: 0,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 1,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 2,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 3,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 4,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 5,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 6,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return data;
           }
        }
    },{
       targets: 7,

       render: function (data, type, row) {
           if(data==null || data ==''){
           		return "<span style='color:#cecece;'>null</span>";
           }else{
	           	return '<span style="color:green; text-transform:lowercase; font-size:14px;">'+data+'</span>';
           }
        }
    },{
       targets: 8,

       render: function (data, type, row) {
           return '<div class="row">'+
           			'<div class="col-md-3">'+
           				'<button class="btn btn-primary" style="font-size:12px; padding:1px 3px;"><i class="fas fa-edit"></i> </button>'+
           			'</div>'+
           			'<div class="col-md-3">'+
           				'<button class="btn btn-danger" style="font-size:12px; padding:1px 3px;"><i class="fas fa-trash"></i> </button>'+
           			'</div>'+
           		'</div>';
       },

   }],

   
   /*columnDefs: [{
       targets: 0,
       
       render: function (data, type, row) {
           return "<textarea>"+data+"</textarea>";
       },

   }],*/

});


$.fn.dataTable.ext.order['dom-text'] = function (settings, col) {
    return this.api()
        .column(col, { order: 'index' })
        .nodes()
        .map(function (td, i) {
            return $('input', td).val();
        });
};
 
/* Create an array with the values of all the input boxes in a column, parsed as numbers */
$.fn.dataTable.ext.order['dom-text-numeric'] = function (settings, col) {
    return this.api()
        .column(col, { order: 'index' })
        .nodes()
        .map(function (td, i) {
            return $('input', td).val() * 1;
        });
};
 
/* Create an array with the values of all the select options in a column */
$.fn.dataTable.ext.order['dom-select'] = function (settings, col) {
    return this.api()
        .column(col, { order: 'index' })
        .nodes()
        .map(function (td, i) {
            return $('select', td).val();
        });
};
 
/* Create an array with the values of all the checkboxes in a column */
$.fn.dataTable.ext.order['dom-checkbox'] = function (settings, col) {
    return this.api()
        .column(col, { order: 'index' })
        .nodes()
        .map(function (td, i) {
            return $('input', td).prop('checked') ? '1' : '0';
        });
};



$(document).ready(function () {
    // Redraw the table
    table.draw();
    
    // Redraw the table based on the custom input
    $('#searchInput,#sortBy').bind("keyup change", function(){
        table.draw();
    });
    /*$("#daterange").click(function(){
      table.draw();
    });*/

});