// Set new default font family and font color to mimic Bootstrap's default styling
Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#858796';

// Pie Chart Example
var ctx = document.getElementById("myPieChart");
var myPieChart = new Chart(ctx, {
  type: 'doughnut',
  data: {
    labels: ["Google Chrome", "Mozilla Firefox", "Safari", "Opera", "IE / Microsoft Edge"],
    datasets: [{
      data: [55, 88, 15, 55, 30],
      backgroundColor: ['#13a05c', '#f2834b', '#16aff1', '#e31225', '#004379'],
      hoverBackgroundColor: ['#2e59d9', '#17a673', '#2c9faf', '#17a673', '#2c9faf'],

      hoverBorderColor: "rgba(234, 236, 244, 1)",
    }],
  },
  options: {
    maintainAspectRatio: false,
    tooltips: {
      backgroundColor: "rgb(255,255,255)",
      bodyFontColor: "#858796",
      borderColor: '#dddfeb',
      borderWidth: 1,
      xPadding: 15,
      yPadding: 15,
      displayColors: false,
      caretPadding: 10,
      callbacks: {
        label: function(tooltipItem, data) {
           var dataset = data.datasets[tooltipItem.datasetIndex];
           
          var total = dataset.data.reduce(function(previousValue, currentValue, currentIndex, array) {
            return previousValue + currentValue;
          });
          //console.log(data);
          var currentValue = dataset.data[tooltipItem.index];
          var LabelsValue = data.labels[tooltipItem.index];
          var precentage = Math.floor(((currentValue/total) * 100)+0.5);
          return LabelsValue +": "+ precentage + "%";
        }
      }
    },
    legend: {
      display: false
    },
    cutoutPercentage: 80,
  },
});
