//
// Pipelining function for DataTables. To be used to the `ajax` option of DataTables
//


//
// DataTables initialisation
//

/*-==============LOGIC condition By MC, VH or not===============*/
if(uri_segment=="mc"){
    var urlDetailsApprove = baseUrlApi+'/data/palms/visitor/details-approve';
    var columnsApprovalDetailVisitor = [
        { data: 'date_visit', orderable:false, className: 'mobile tablet desktop'},
        { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'status_visitor' },
        { data: 'approval_mc' },
        { data: 'interview_mc_note' },
        { data: 'date_interview' }
    ];
    var columnDefsApprovalDetailVisitor = [
            {
                targets:3,
                render:function(data,type,row){
                    if (data == 0) {
                       return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                   }else if (data == 1){
                      return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                   }else if (data == 2){
                      return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                   }else if (data == 3){
                      return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                   }
                }
            },{
                targets:4,
                render:function(data,type,row){
                    if (data == 0) {
                        return "<div style='cursor:text;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                    }else if (data == 1){
                        return "<div style='text-align: center; display:block;'><span class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Approved</span></div>";
                    }else if (data == 2){
                        return "<div style='text-align: center; display:block;'><span class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Pending</span></div>";
                    }else if (data == 3){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-default' style='cursor:text; padding:2px; font-size:10px;'>Not Approved</span></div>";
                    }else{
                        return "<div style='cursor:text;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                    }
                }
            },{
                targets:6,
                render:function(data,type,row){
                    return moment(data).format('YYYY-MM-DD');
                }
            },

            
        ];
   var columnsDataTable = [
        
        { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'number_contact' },
        { data: 'bussines_description' },
        /*{ data: 'name_sponsor' },*/
        { data: 'status_visitor' },

        { data: 'approval_mc', className:"set_approval_mc"},
        { data: 'interview_mc_note', "width": "40%", className:"set_note_mc" },
        { data: 'id_interview', },
        { data: 'date_interview'},
        { data: null, },
        
        
    ];

    var fieldsEditor = [{
                type: "datetime",
                label: "Note Interview:",
                name: "date_visit"
            },{
                type: "select",
                label: "Approval MC:",
                name: "approval_mc",
                
            },{
                type: "textarea",
                label: "Note Interview:",
                name: "interview_mc_note"
            },{
                type: "datetime",
                label: "Tanggal Interview:",
                name: "date_interview"
            }

        ];

    var buttonImportExport = [
        {
            extend: 'csv',
            text: '<i class="fas fa-file-export"></i> Export CSV',
            className: 'MBottom15 btn-space btn btn-warning fontSz12',
            exportOptions: {
                orthogonal: null
            }
        },{
            text: '<i class="fas fa-paper-plane"></i> Approve',
            className: 'MBottom15 btn btn-success fontSz12 btn-approval',
            action: function () {
                tableDetailsApprove.clear();
                var dataTable = $('#dataTable').DataTable();    
                    
                
                $('#ModalDataTableDetailsApprove').modal('show');
                tableDetailsApprove.draw();

                $('#ModalDataTableDetailsApprove').on('click', '#yes-approve', function (e) { 
                    var params = e.target.dataset.id;
                    $("#key_approval_vh__").val(params);
                    $("#ModalDataTableDetailsApprove").modal('hide');
                    $("#dataTableConfirmApprove").modal('show');
                    
                }); 
            }
        },
    ];

    var fieldsEditorImport = [{
                label: "Tanggal Interview:",
                name: "date_interview",
                type: "datetime",
                def:    function () { return new Date(); },
                format: 'YYYY-M-D',
            }, {
                label: "Nama Visitor:",
                name: "interview_mc_note",
                type:'textarea'
            }, {
                type: "select",
                label: "Approval MC:",
                name: "approval_mc",
            }
        ];

    var columnDefsDataTable = [
            {
                targets:8,
                render:function(data,type,row){
                    if(data){
                        return moment(data).format('YYYY-MM-DD');
                    }else{
                        return '<p style="color: #cecece !important;">NULL</p>';
                    }
                }
            },{
               targets: 4,
               
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                   }else if (data == 1){
                      return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                   }else if (data == 2){
                      return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                   }else if (data == 3){
                      return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                   }
               },

            },{
               targets: 5,
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<div style='cursor:pointer;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                   }else if (data == 1){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-success' style='padding:2px; font-size:10px;'>Approved</span></div>";
                   }else if (data == 2){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-danger' style='padding:2px; font-size:10px;'>Pending</span></div>";
                   }else if (data == 3){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-default' style='padding:2px; font-size:10px;'>Not Approved</span></div>";
                   }else{
                        return "<div style='cursor:pointer;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                   }
               },

            },{
               targets: 6,
               render: function (data, type, row) {
                    if(data!=null){
                        return "<span style=' color: #c8c8c8 !important; cursor: pointer; display: block; text-align: right;'>Click in here <i class='fas fa-edit'></i></span><p><span style='color: #0070ff !important;'>"+data+"</span></p>";
                    }else{
                        return "<span style=' color: #c8c8c8 !important; cursor: pointer; display: block; text-align: right;'>Click in here <i class='fas fa-edit'></i></span>";
                        
                    }
               },

            },{
                "width": "15%",
                targets: 7,
                render: function (data, type, row) {
                    //console.log(data);

                //console.log(data.verify_page);
                    if (parseInt(data.verify_page)===0) {
                        if(row.approval_mc==1 && row.approval_mc!=null && row.interview_mc_note!=null || row.approval_mc==1 && row.interview_mc_note!=null){
                            return "<a style='text-align: center; display: block; margin: auto;' target='_blank' href='http://pejompongan22.dupawangi.com:8084/portal_mc/portal/palms/interview/generate-visitor?intvwcd="+data.id+"'><button style='font-size: 10px; padding: 5px 4px;' class='btn btn-primary'><i class='fas fa-link'></i>Interview</button></a>";
                        }else{
                            return "<a style='text-align: center; display: block; margin: auto;' target='_blank' href='#'><button style='font-size: 10px; padding: 5px 4px; cursor:no-drop;' class='btn btn-primary' disabled><i class='fas fa-link'></i>Interview</button></a>";
                        }
                    }else{
                        return '<p style="color:#3dae13; font-size:18px; display:block; margin:auto; text-align:center;"><i class="fas fa-check"></i></p>';                                
                    }
                },

            },{
                targets: 9,
                data: null,
                className: "editor-edit-mc",
                orderable: false,
                render: function (data, type, row) {

                    return '<div class="row">'+
                            '<div class="col-md-3">'+
                                '<button class=" btn btn-warning " style="font-size:12px; padding:1px 3px;"><i class="fas fa-edit"></i> </button>'+
                            '</div>'+
                        '</div>';
                },

            },
        ];
}else if(uri_segment=="st"){
        var urlDetailsApprove = baseUrlApi+'/data/palms/visitor/details-approve-st';
        var columnsApprovalDetailVisitor = [
            { data: 'date_visit', className:"set_date_interview"},
            { data: 'date_interview', className:"set_date_interview"},
            { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'status_visitor' },
            { data: 'number_contact' },
            { data: 'bussines_description' },
            /*{ data: 'name_sponsor' },*/
            

            { data: 'approval_mc', className:"set_approval_mc"},
            { data: 'interview_mc_note', "width": "40%", className:"set_note_mc" },
            { data: 'id_interview', },
            { data: null, },
        ];
        var columnDefsApprovalDetailVisitor = [
            {
                targets:0,
                render:function(data,type,row){
                    if(data){
                        return moment(data).format('YYYY-MM-DD');
                    }else{
                        return '<p style="color: #cecece !important;">NULL</p>';
                    }
                }
            },{
               targets: 4,
               
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                   }else if (data == 1){
                      return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                   }else if (data == 2){
                      return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                   }else if (data == 3){
                      return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                   }
               },

            },{
               targets: 7,
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<div style='cursor:pointer;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                   }else if (data == 1){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-success' style='padding:2px; font-size:10px;'>Approved</span></div>";
                   }else if (data == 2){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-danger' style='padding:2px; font-size:10px;'>Pending</span></div>";
                   }else if (data == 3){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-default' style='padding:2px; font-size:10px;'>Not Approved</span></div>";
                   }else{
                        return "<div style='cursor:pointer;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                   }
               },

            },{
               targets: 8,
               render: function (data, type, row) {
                    return "<span style='color: #0070ff !important;'>"+data+"</span>";
               },

            },{
                "width": "15%",
                targets: 9,
                render: function (data, type, row) {
                //console.log(data.verify_page);
                    if (parseInt(data.verify_page)===0) {
                        return "<a style='text-align: center; display: block; margin: auto;' target='_blank' href='http://pejompongan22.dupawangi.com:8084/portal_mc/portal/palms/interview/generate-visitor?intvwcd="+data.id+"'><button style='font-size: 10px; padding: 5px 4px;' class='btn btn-primary'><i class='fas fa-link'></i>Interview</button></a>";
                    }else{
                        return '<p style="color:#3dae13; font-size:18px; display:block; margin:auto; text-align:center;"><i class="fas fa-check"></i></p>';                                
                    }
                },

            },{
                targets: 10,
                data: null,
                orderable: false,
                className:'upload-docs-st',
                render: function (data, type, row) {
                        if(row.date_payment && row.docs_upload){
                        return '<p style="color:#3dae13; font-size:18px; display:block; margin:auto; text-align:center;"><i class="fas fa-check"></i></p>'; 
                        }else{
                            return '<div class="row ">'+
                            '<div class="col-md-3">'+
                                '<button class=" btn btn-primary " style="font-size:12px; padding:1px 3px;" title="Edit & Upload Docs"><i class="fas fa-upload"></i>  </button>'+
                            '</div>'+
                        '</div>';
                        }

                         
                  
                   
                },

            }
        ];
       var columnsDataTable = [
            { data: 'date_interview', className:"set_date_interview"},
            { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'number_contact' },
            { data: 'bussines_description' },
            /*{ data: 'name_sponsor' },*/
            { data: 'status_visitor' },

            { data: 'approval_mc', className:"set_approval_mc"},
            { data: 'interview_mc_note', "width": "40%", className:"set_note_mc" },
            { data: 'id_interview', },
            { data: null, },
        ];

        var fieldsEditor = [{
                type: "datetime",
                label: "Note Interview:",
                name: "date_visit"
            },{
                type: "select",
                label: "Approval MC:",
                name: "approval_mc",
                
            },{
                type: "textarea",
                label: "Note Interview:",
                name: "interview_mc_note"
            },{
                type: "datetime",
                label: "Tanggal Interview:",
                name: "date_interview"
            }

        ];

        var buttonImportExport = [
            {
                extend: 'csv',
                text: '<i class="fas fa-file-export"></i> Export CSV',
                className: 'MBottom15 btn-space btn btn-warning fontSz12',
                exportOptions: {
                    orthogonal: null
                }
            },{
                text: '<i class="fas fa-paper-plane"></i> Approve',
                className: 'MBottom15 btn btn-success fontSz12 btn-approval',
                action: function () {
                    tableDetailsApprove.clear();
                    var dataTable = $('#dataTable').DataTable();    
                        
                    
                    $('#ModalDataTableDetailsApprove').modal('show');
                    tableDetailsApprove.draw();

                    $('#ModalDataTableDetailsApprove').on('click', '#yes-approve', function (e) { 
                        var params = e.target.dataset.id;
                        $("#key_approval_vh__").val(params);
                        $("#ModalDataTableDetailsApprove").modal('hide');
                        $("#dataTableConfirmApprove").modal('show');
                        
                    }); 
                }
            },
        ];

        var fieldsEditorImport = [{
                    label: "Tanggal Interview:",
                    name: "date_interview",
                    type: "datetime",
                    def:    function () { return new Date(); },
                    format: 'YYYY-M-D',
                }, {
                    label: "Nama Visitor:",
                    name: "interview_mc_note",
                    type:'textarea'
                }, {
                    type: "select",
                    label: "Approval MC:",
                    name: "approval_mc",
                }
            ];

        var columnDefsDataTable = [
            {
                targets:0,
                render:function(data,type,row){
                    if(data){
                        return moment(data).format('YYYY-MM-DD');
                    }else{
                        return '<p style="color: #cecece !important;">NULL</p>';
                    }
                }
            },{
               targets: 5,
               
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                   }else if (data == 1){
                      return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                   }else if (data == 2){
                      return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                   }else if (data == 3){
                      return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                   }
               },

            },{
               targets: 6,
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<div style='cursor:pointer;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                   }else if (data == 1){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-success' style='padding:2px; font-size:10px;'>Approved</span></div>";
                   }else if (data == 2){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-danger' style='padding:2px; font-size:10px;'>Pending</span></div>";
                   }else if (data == 3){
                      return "<div style='text-align: center; display:block;'><span class='btn btn-default' style='padding:2px; font-size:10px;'>Not Approved</span></div>";
                   }else{
                        return "<div style='cursor:pointer;text-align: center; display:block;'><span style='color: green !important;'>Please Approve</span></div>";
                   }
               },

            },{
               targets: 7,
               render: function (data, type, row) {
                    return "<span style='color: #0070ff !important;'>"+data+"</span>";
               },

            },{
                "width": "15%",
                targets: 8,
                render: function (data, type, row) {
                //console.log(data.verify_page);
                    if (parseInt(data.verify_page)===0) {
                        return "<a style='text-align: center; display: block; margin: auto;' target='_blank' href='http://pejompongan22.dupawangi.com:8084/portal_mc/portal/palms/interview/generate-visitor?intvwcd="+data.id+"'><button style='font-size: 10px; padding: 5px 4px;' class='btn btn-primary'><i class='fas fa-link'></i>Interview</button></a>";
                    }else{
                        return '<p style="color:#3dae13; font-size:18px; display:block; margin:auto; text-align:center;"><i class="fas fa-check"></i></p>';                                
                    }
                },

            },{
                targets: 9,
                data: null,
                orderable: false,
                className:'upload-docs-st',
                render: function (data, type, row) {
                        if(row.date_payment && row.docs_upload){
                        return '<div class="row">'+
                                '<div class="col-md-3">'+
                                    '<button class=" btn btn-warning " style="font-size:12px; padding:1px 3px; cursor:pointer;" title="Details Docs"><i class="fas fa-search-plus"></i>  </button>'+
                                '</div>'+
                            '</div>';
                        }else{
                            return '<div class="row ">'+
                            '<div class="col-md-3">'+
                                '<button class=" btn btn-primary " style="font-size:12px; padding:1px 3px;" title="Edit & Upload Docs"><i class="fas fa-upload"></i>  </button>'+
                            '</div>'+
                        '</div>';
                        }

                         
                  
                   
                },

            }
        ];
}else if(uri_segment=="approved"){
    var urlDetailsApprove = baseUrlApi+'/data/palms/visitor/details-approve-st';
        var columnsApprovalDetailVisitor = [
            { data: 'date_visit', orderable:false, className: 'mobile tablet desktop'},
            { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'status_visitor' }
        ];
        var columnDefsApprovalDetailVisitor = [
                {
                    targets:3,
                    render:function(data,type,row){
                        if (data == 0) {
                           return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                       }else if (data == 1){
                          return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                       }else if (data == 2){
                          return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                       }else if (data == 3){
                          return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                       }
                    }
                },
            ];
       var columnsDataTable = [
            { data: 'date_interview', className:"set_date_interview"},
            { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
            { data: 'number_contact' },
            { data: 'bussines_description' },
            /*{ data: 'name_sponsor' },*/
            { data: 'status_visitor' },

            { data: 'approval_mc', className:"set_approval_mc"},
            { data: 'interview_mc_note', "width": "40%"},
            { data: 'id_interview', },
            { data: null, },
            
        ];

        var fieldsEditor = [{
                type: "datetime",
                label: "Note Interview:",
                name: "date_visit"
            },{
                type: "select",
                label: "Approval MC:",
                name: "approval_mc",
                
            },{
                type: "textarea",
                label: "Note Interview:",
                name: "interview_mc_note"
            },{
                type: "datetime",
                label: "Tanggal Interview:",
                name: "date_interview"
            }

        ];



        var buttonImportExport = [
            {
                extend: 'csv',
                text: '<i class="fas fa-file-export"></i> Export CSV',
                className: 'MBottom15 btn-space btn btn-warning fontSz12',
                exportOptions: {
                    orthogonal: null
                }
            }
        ];

        var fieldsEditorImport = [{
                    label: "Tanggal Interview:",
                    name: "date_interview",
                    type: "datetime",
                    def:    function () { return new Date(); },
                    format: 'YYYY-M-D',
                }, {
                    label: "Nama Visitor:",
                    name: "interview_mc_note",
                    type:'textarea'
                }, {
                    type: "select",
                    label: "Approval MC:",
                    name: "approval_mc",
                }
            ];

        var columnDefsDataTable = [
            {
                targets:0,
                render:function(data,type,row){
                    if(data){
                        return moment(data).format('YYYY-MM-DD');
                    }else{
                        return '<p style="color: #cecece !important;">NULL</p>';
                    }
                }
            },{
               targets: 5,
               
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                   }else if (data == 1){
                      return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                   }else if (data == 2){
                      return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                   }else if (data == 3){
                      return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                   }
               },

            },{
               targets: 6,
               render: function (data, type, row) {
                   if (data == 0) {
                       return "<div style='cursor:tex !important;text-align: center; display:block;'><span style='cursor:text !important; color: green !important;'>Please Approve</span></div>";
                   }else if (data == 1){
                      return "<div style='cursor:text !important; text-align: center; display:block;'><span class='btn btn-success' style='cursor:text !important; padding:2px; font-size:10px;'>Approved</span></div>";
                   }else if (data == 2){
                      return "<div style='cursor:text !important; text-align: center; display:block;'><span class='btn btn-danger' style='cursor:text !important; padding:2px; font-size:10px;'>Pending</span></div>";
                   }else if (data == 3){
                      return "<div style='cursor:text !important; text-align: center; display:block;'><span class='btn btn-default' style='cursor:text !important; padding:2px; font-size:10px;'>Not Approved</span></div>";
                   }else{
                        return "<div style='cursor:text !important;text-align: center; display:block;'><span style='cursor:text !important; color: green !important;'>Please Approve</span></div>";
                   }
               },

            },{
               targets: 7,
               render: function (data, type, row) {
                    return "<span style='cursor:text !important;'>"+data+"</span>";
               },

            },{
                "width": "15%",
                targets: 8,
                className: "details-interview-visitor",
                render: function (data, type, row) {
                //console.log(data.verify_page);
                   return '<div class="row">'+
                            '<div class="col-md-12" style="text-align:center;">'+
                                '<button class=" btn btn-warning " style=" font-size:12px; padding:1px 3px;" title="Details Results Interview"><i class="fas fa-info-circle"></i></button> <p>Results Interview</p>'+
                            '</div>'+
                        '</div>';
                },

            },{
                targets: 9,
                data: null,
                className: "details-docs-visitor",
                orderable: false,
                render: function (data, type, row) {

                    return '<div class="row">'+
                            '<div class="col-md-12" style="text-align:center;">'+
                                '<button class=" btn btn-primary " style=" font-size:12px; padding:1px 3px;" title="Details document visitor"><i class="fas fa-info-circle"></i></button><p>Documents Visitor</p>'+
                            '</div>'+
                        '</div>';
                },

            },
        ];
}else{
    var urlDetailsApprove = baseUrlApi+'/data/palms/visitor/details-approve';
    var columnsApprovalDetailVisitor = [
        { data: 'date_visit', orderable:false, className: 'mobile tablet desktop'},
        { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'status_visitor' }
    ];
    var columnDefsApprovalDetailVisitor = [
            {
                targets:3,
                render:function(data,type,row){
                    if (data == 0) {
                       return "<span id='proccess-edit' class='btn btn-primary' style='cursor:text; padding:2px; font-size:10px;'>New</span>";
                   }else if (data == 1){
                      return "<span id='proccess-edit' class='btn btn-success' style='cursor:text; padding:2px; font-size:10px;'>Interest</span>";
                   }else if (data == 2){
                      return "<span id='proccess-edit' class='btn btn-warning' style='cursor:text; padding:2px; font-size:10px;'>Need to know more</span>";
                   }else if (data == 3){
                      return "<span id='proccess-edit' class='btn btn-danger' style='cursor:text; padding:2px; font-size:10px;'>Not interest</span>";
                   }
                }
            },
        ];
    var columnsDataTable = [
        { data: 'date_visit', orderable:false, className: 'mobile tablet desktop'},
        { data: 'first_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'last_name', orderable:false, className: 'mobile tablet desktop' },
        { data: 'number_contact' },
        { data: 'bussines_description' },
        { data: 'name_sponsor' },

        /*{ data: 'approval_mc' },
        { data: 'interview_mc_note', "width": "40%" },*/
        { data: 'status_visitor' },
        { data: null, },
        { data: null, },
    ];

    var fieldsEditor = [{
                type: "text",
                label: "Nama Visitor:",
                name: "name_visitor"
            },{
                type: "text",
                label: "number_contact:",
                name: "number_contact"
            },{
                type: "textarea",
                label: "Deskripsi Bisnis:",
                name: "bussines_description",
                
            },{
                type: "text",
                label: "Nama Sponsor:",
                name: "name_sponsor",
                
            },{
                    label: "Status Visitor :",
                    name:  "status_visitor", //render creditor name
                    type: "select",
                    options : { 
                        render:1
                    }
                },
        ];

        var buttonImportExport = [
        {
            extend: 'csv',
            text: '<i class="fas fa-file-export"></i> Export CSV',
            className: 'MBottom15 btn-space btn btn-warning fontSz12',
            exportOptions: {
                orthogonal: null
            }
        },
        {
            text: '<i class="fas fa-file-import"></i> Import CSV',
            className: 'MBottom15 btn btn-primary fontSz12',
            action: function () {
                
                $("#editImportDataVH").modal('show');
                /*uploadEditor.create( {
                    title: 'Import Data'
                } );*/
            }
        },
        {
            text: '<i class="fas fa-paper-plane"></i> Approve',
            className: 'MBottom15 btn btn-success fontSz12 btn-approval',
            action: function () {
                tableDetailsApprove.clear();
                var dataTable = $('#dataTable').DataTable();    
                    
                
                $('#ModalDataTableDetailsApprove').modal('show');
                tableDetailsApprove.draw();

                $('#ModalDataTableDetailsApprove').on('click', '#yes-approve', function (e) { 
                    var params = e.target.dataset.id;
                    $("#key_approval_vh__").val(params);
                    $("#ModalDataTableDetailsApprove").modal('hide');
                    $("#dataTableConfirmApprove").modal('show');
                    
                }); 
            }
        },
    ];

        var fieldsEditorImport = [{
                label: "Tanggal Visit:",
                name: "date_visit",
                type: "datetime",
                def:    function () { return new Date(); },
                format: 'YYYY-M-D',
            }, {
                label: "Nama Visitor:",
                name: "name_visitor",
                type:'text'
            }, {
                label: "Nomor Kontak:",
                name: "number_contact",
                type:'text'
            }, {
                label: "Deskripsi Bisnis:",
                name: "bussines_description",
                type:'textarea'
            }, {
                label: "Nama Sponsor:",
                name: "name_sponsor",
                type:'text'
            }, {
                label: "status VOR:",
                name: "status_visitor",
                type:'select'
            }
        ];

        var columnDefsDataTable = [
                    {
                        targets:0,
                        render:function(data,type,row){
                            return moment(data).format('YYYY-MM-DD');
                        }
                    },
                    /*{
                       targets: 5,
                       render: function (data, type, row) {*/
                        //console.log(data);
                           /* if (data !== null && data!=0) {
                                if(parseInt(data)===1){
                                    return "<span class='btn btn-success' style='padding:0px 15px; font-size:10px;'>"+'YES'+"</span>";
                                }
                                if(parseInt(data)===2){
                                    return "<span class='btn btn-danger' style='padding:1px 7px; font-size:10px;'>"+'NO'+"</span>";
                                }
                                if(parseInt(data)===3){
                                    return "<span class='btn btn-warning' style='padding:1px 7px; font-size:10px;'>"+'CLOSE'+"</span>";
                                }
                            }else{
                                return "<span style='color:#cecece;'>null</span>";
                            }
                       },

                   },*/
                   {
                       targets: 6,
                       className:'approval_edit',
                       render: function (data, type, row) {
                           if (data == 0) {
                               return "<span class='btn btn-primary' style='padding:2px; font-size:10px;'>New</span>";
                           }else if (data == 1){
                              return "<span class='btn btn-success' style='padding:2px; font-size:10px;'>Interest</span>";
                           }else if (data == 2){
                              return "<span class='btn btn-warning' style='padding:2px; font-size:10px;'>Need to know more</span>";
                           }else if (data == 3){
                              return "<span class='btn btn-danger' style='padding:2px; font-size:10px;'>Not interest</span>";
                           }
                       },

                   },{
                        targets: 7,
                        data: null,
                        className: "editor-edit-vh",
                        orderable: false,
                        render: function (data, type, row) {

                            return '<div class="row">'+
                                    '<div class="col-md-3">'+
                                        '<button class=" btn btn-warning " style="font-size:12px; padding:1px 3px;"><i class="fas fa-edit"></i> </button>'+
                                    '</div>'+
                                '</div>';
                        },

                   },{
                        targets: 8,
                        data: null,
                        className: "editor_remove",
                        orderable: false,
                        render: function (data, type, row) {

                            return '<div class="row">'+
                                    '<div class="col-md-3">'+
                                        '<button class="btn btn-danger" style="font-size:12px; padding:1px 3px;"><i class="fas fa-trash"></i> </button>'+
                                    '</div>'+
                                '</div>';
                        },

                   },
                   
                   /*{
                       targets: 6,

                       render: function (data, type, row) {
                            if (data){
                                return '<div style="width: 100%;display: block;'+
                                        'position: relative;color: #0a5b16;padding: 5px 15px;'+
                                        'box-shadow: 1px 2px 3px 1px #f7f7f7">'+
                                        data+
                                        '</div>';
                            }else{
                                return '';
                            }
                       },

                   },*/
        ];
}

/*------------------------------------------------------------------------*/

var editorImport;

/*function selectColumns ( editor, csv, header ) {
    var selectEditor = new $.fn.dataTable.Editor();
    var fields = editor.order();
 
    for ( var i=0 ; i<fields.length ; i++ ) {
        var field = editor.field( fields[i] );
 
        selectEditor.add( {
            label: field.label(),
            name: field.name(),
            type: 'select',
            options: header,
            def: header[i]
        } );
    }
 
    selectEditor.create({
        title: 'Map CSV fields',
        buttons: 'Import '+csv.length+' records',
        message: 'Select the CSV column you want to use the data from for each field.',
        onComplete: 'none'
    });
 
    selectEditor.on('submitComplete', function (e, json, data, action) {
       
        editor.create( csv.length, {
            title: 'Confirm import',
            buttons: 'Submit',
            message: 'Click the <i>Submit</i> button to confirm the import of '+csv.length+' rows of data. Optionally, override the value for a field to set a common value by clicking on the field below.'
        } );
 
        for ( var i=0 ; i<fields.length ; i++ ) {
            var field = editor.field( fields[i] );
            var mapped = data[ field.name() ];
 
            for ( var j=0 ; j<csv.length ; j++ ) {
                field.multiSet( j, csv[j][mapped] );
            }
        }
    } );
}*/

/*var uploadEditor = new $.fn.dataTable.Editor( {
        fields: [ {
            label: 'CSV file:',
            name: 'csv',
            type: 'upload',
            ajax: function ( files, done ) {
                Papa.parse(files[0], {
                    header: true,
                    skipEmptyLines: true,
                    complete: function (results) {
                        if ( results.errors.length ) {
                            console.log( results );
                            uploadEditor.field('csv').error( 'CSV parsing error: '+ results.errors[0].message );
                        }
                        else {
                            selectColumns( editorImport, results.data, results.meta.fields );
                        }
                        done([0]);
                    }
                });
            }
        } ]
    } );*/



$('#daterange').daterangepicker({
    "format": 'Y-m-d H:i:s',
    "startDate": moment().subtract(29, 'days').format('YYYY/MM/DD'),
    "endDate": moment().format('YYYY/MM/DD'),
    "opens": "center",
    "showDropdowns": true,
    locale: {
      format: 'YYYY/MM/DD'
    },
}, function(start, end, label) {
$("#daterange").val(start.format('YYYY/MM/DD')+" - "+end.format('YYYY/MM/DD'));
  table.draw();
  tableDetailsApprove.draw();
  //var this.start_date = start.format('YYYY-MM-DD')?start.format('YYYY-MM-DD'):'sas';
  //console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
});


var tableDetailsApprove = $('#dataTableDetailsApprove').DataTable({
    processing  : true,
    serverSide  : true,
    responsive  : true,
    paging: true,
    ajax        :   {
                method:'POST',
                url: urlDetailsApprove,
                pages: 5, // number of pages to cache
                data: function ( d ) {
                    
                    return $.extend( {}, d, {
                        "filter_daterange": $("#daterange").val(),
                        "uri_segment": uri_segment ? uri_segment :'',
                    });
                },
                error: function(){  
                },
            },
    "drawCallback": function (settings) { 

        if(settings.json.err_code==200){
            $(document).ready(function () {
            $( ".btn-approval" ).prop( "disabled", false );
            $(".btn-approval").css("cursor", "pointer");
        });
        }else{
            $(document).ready(function () {
                $( ".btn-approval" ).prop( "disabled", true );
                $(".btn-approval").css("cursor", "no-drop");
            });
        }
    },
    columns     :columnsApprovalDetailVisitor,
    columnDefs  :columnDefsApprovalDetailVisitor
});


var table = $('#dataTable').DataTable({
    dom: 'Bfrtip',
    processing      : true,
    serverSide      : true,
    responsive: true,
   // scrollX: true,
    /*scrollY         : true,
    scrollX         : true,
    scrollCollapse  : true,
    fixedColumns    :   {
        leftColumns     : 1,
        rightColumns    : 2
    },*/
    
    select: true,
    buttons: buttonImportExport,
  ajax:{
      method:'POST',
      url: baseUrlApi+'/data/palms/visitor',
      pages: 5, // number of pages to cache
      data: function ( d ) {
         return $.extend( {}, d, {
           "filter_daterange": $("#daterange").val(),
           "uri_segment": uri_segment ? uri_segment :'',
         } );

       },
      error: function(){  
      },

      
  },


  columns: columnsDataTable,
  columnDefs: columnDefsDataTable
});



$('#dataTable').on( 'click', 'li.editor-edit', function (e) {
        // Edit the value, but this selector allows clicking on label as well
         editorImport.edit( $(this).closest('tr li'), {
            title: 'Edit record',
            buttons: 'Update'
        } );
    } );


var editor;


    /*$('#dataTable').on( 'click', 'tbody tr .approval_edit', function (e) {
        
        console.log($('#dataTable').DataTable().rows( $(this) ).data()); 

    } );*/



    if(uri_segment=="mc"){
        /*prosess visitor MC*/

        $('#dataTable').on('click', 'tbody tr .set_date_interview', function (e) {    
        //fnResetControls();    
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');
            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            const status_visitor = $('#dataTable').DataTable().rows( $(this) ).data()[0].status_visitor;
            $("#key_date_interview").val(key);     
            $("#approvalVh").val(status_visitor).attr('selected', 'selected');
            $('#SetDateInterviewMC').modal('show');
        }); 


        $('#dataTable').on('click', 'tbody tr .set_approval_mc', function (e) {    
        //fnResetControls();   
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');
            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            var status_approval_mc = $('#dataTable').DataTable().rows( $(this) ).data()[0].approval_mc;
            //console.log(status_approval_mc); return false;
            if(status_approval_mc==0){
                status_approval_mc = '';
            }
            $("#key_approval_mc").val(key);     
            $("#approvalMc").val(status_approval_mc).attr('selected', 'selected');
            $('#editApprovalMC').modal('show');
        }); 

        $('#dataTable').on('click', 'tbody tr .set_note_mc', function (e) {    
        //fnResetControls();  

            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');
            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            var interview_mc_note = $('#dataTable').DataTable().rows( $(this) ).data()[0].interview_mc_note;
            $("#interview_mc_note").val(interview_mc_note); 
            //console.log(status_approval_mc); return false;
            $("#key_note_mc").val(key);     
            $('#editNoteInterviewMC').modal('show');
        }); 

        $('#dataTable').on('click', 'tbody tr .editor-edit-mc', function (e) {    
        //fnResetControls();    
            $("textarea#interview_mc_note").val('');
            //console.log($('#dataTable').DataTable().rows( $(this) ).data());
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');

            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            var date_interview = $('#dataTable').DataTable().rows( $(this) ).data()[0].date_interview;
            var status_approval_mc = $('#dataTable').DataTable().rows( $(this) ).data()[0].approval_mc;


            //console.log(status_approval_mc); return false;
            if(status_approval_mc==0){
                status_approval_mc = '';
            }
            if (!date_interview) {
                date_interview = '';
            }
            //console.log(date_interview); return false;
            const interview_mc_note = $('#dataTable').DataTable().rows( $(this) ).data()[0].interview_mc_note;
            
            $("#key_edit_form_mc").val(key);   
            /*$("#form_edit_date_interview").val(date_interview);*/
            $("#approvalFormEditMc").val(status_approval_mc).attr('selected', 'selected');
            $("textarea#interview_mc_note").val(interview_mc_note);
            $('#editFormMC').modal('show');
        });
        

    }else if(uri_segment=="st"){

        var isValid = $(".form-interview");
        isValid.validate({
            errorClass: "is-invalid",
            rules:{
                payment_date:{
                    required: true,
                },
                file_docs:{
                    required: true,
                }
            },
            messages: {
                
                file_docs: {
                    required: "<p style='color:#e74a3b; font-size:16px;'>Field 'Upload Docs' is required</p>",
                },
                payment_date:{
                    required: "<p style='color:#e74a3b; font-size:16px;'>Field 'Payment Date' is required</p>",
                }
            },
            errorPlacement: function(error, element) 
            {
                if ( element.is(":radio") ) 
                {
                    error.appendTo( element.parents('.container') );
                }
                else 
                { // This is the default behavior 
                    error.insertAfter( element );
                }
             }
        });

        $('#dataTable').on('click', 'tbody tr .upload-docs-st', function (e) {    
        //fnResetControls();
            $("textarea#interview_mc_note").val('');    
            $("#details-dt-docs-image").html('');
            //console.log($('#dataTable').DataTable().rows( $(this) ).data());
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');

            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            var date_interview = $('#dataTable').DataTable().rows( $(this) ).data()[0].date_interview;
            var status_approval_mc = $('#dataTable').DataTable().rows( $(this) ).data()[0].approval_mc;


            //console.log(status_approval_mc); return false;
            if(status_approval_mc==0){
                status_approval_mc = '';
            }
            if (!date_interview) {
                date_interview = '';
            }
            //console.log(date_interview); return false;
            const interview_mc_note = $('#dataTable').DataTable().rows( $(this) ).data()[0].interview_mc_note;

            var docs_upload = $('#dataTable').DataTable().rows( $(this) ).data()[0].docs_upload;
            if(docs_upload){
                var dt_docs_upload_image = JSON.parse(docs_upload).data_docs_images;
                var dt_docs_upload_file = JSON.parse(docs_upload).data_docs_file;
                
                var html_dt_docs_image = '';
                html_docs_image = '';
                //dt_docs_upload_image.forEach(viewHtmlDetailsDocsImage);
                for (var i = 0; i < dt_docs_upload_image.length; i++) {
                    html_docs_image += '<div class="col-md-3" style="margin-bottom:20px;">'+
                        '<img style="width:100%;" src="'+baseUrlApi+'/writable/uploads/'+dt_docs_upload_image[i].name+'" title="" />'+
                    '</div>'
                    ; 
                }
                
                $(".alert-info-docs-image").css("display","none");
                $("#details-dt-docs-image").html(html_docs_image);
                $("#details-dt-docs-file").html("<ul style='overflow:auto;'><li><a href='"+baseUrlApi+"/writable/uploads/"+dt_docs_upload_file.name+"'>"+dt_docs_upload_file.name+"</a></li></ul>");
                $(".alert-info-docs-file").css("display","none");
                $('#DetailsDocumentsVisitor').modal('show');
            }else{
                $("#key_upload_docs").val(key);   
                /*$("#form_edit_date_interview").val(date_interview);*/
                $("#approvalFormEditMc").val(status_approval_mc).attr('selected', 'selected');
                $("textarea#interview_mc_note").val(interview_mc_note);
                $('#editFormST').modal('show');
            }
        });

        $("#frmdata_upload_docs").on('submit', function(e){
            if(!isValid.valid()){
                //console.log("aweu");
                return false;
            }
            //console.log("test");
            //return false;
            e.preventDefault();
            $.ajax({
                type: 'POST',
                url: baseUrlApi+'/portal/palms/visitor/st/upload-docs',
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData:false,
                beforeSend: function(){
                    $("#err_message_import").html('');
                    $( "#submit_vh" ).prop( "disabled", true );
                    $("#submit_vh").css("cursor", "no-drop");
                    $(".loading-form").css("display","block");
                    /*$('.submitBtn').attr("disabled","disabled");
                    $('#fupForm').css("opacity",".5");*/
                },
                success: function(response){
                    //var resp = JSON.parse(response);
                    //console.log(resp.err_code);
                    if(response.err_code==200){
                        $("#err_message_import").html(
                            '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                                '<strong>'+response.err_message+'!</strong>'+
                                '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                    '<span aria-hidden="true">&times;</span>'+
                                '</button>'+
                            '</div>'
                            );
                        $( "#submit_vh" ).prop( "disabled", false );
                        $("#submit_vh").css("cursor", "pointer");
                        $(".loading-form").css("display","none");
                        $('#DetailsDocumentsVisitor').modal('hide');
                        $("#editFormST").modal('hide');
                        document.getElementById("import_visitor").value ='';
                        $("input[name=images").val('');
                        $("input[name=file_docs]").val('');
                        $(".image-uploader").remove();

                        table.draw(); 
                        tableDetailsApprove.draw(); 
                         $('.input-docs-1').imageUploader();
                    }else{
                        $("#err_message_import").html('');
                        $( "#submit_vh" ).prop( "disabled", false );
                        $("#submit_vh").css("cursor", "pointer");
                        $(".loading-form").css("display","none");
                        $("#err_message_import").html(
                            '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                                '<strong>General Error or duplicate name visitor!</strong>'+
                                '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                    '<span aria-hidden="true">&times;</span>'+
                                '</button>'+
                            '</div>'
                            );
                    }

                }
            });
        });
    }else if(uri_segment=='approved'){
        
        
        $('#dataTable').on('click', 'tbody tr .details-docs-visitor', function (e) { 
        $("#details-dt-docs-image").html('dsfdsf');   
        //fnResetControls();    

            //console.log($('#dataTable').DataTable().rows( $(this) ).data());
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');

            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            var docs_upload = $('#dataTable').DataTable().rows( $(this) ).data()[0].docs_upload;
            var dt_docs_upload_image = JSON.parse(docs_upload).data_docs_images;
            var dt_docs_upload_file = JSON.parse(docs_upload).data_docs_file;
            
            var html_dt_docs_image = '';
            html_docs_image = '';
            //dt_docs_upload_image.forEach(viewHtmlDetailsDocsImage);
            for (var i = 0; i < dt_docs_upload_image.length; i++) {
                html_docs_image += '<div class="col-md-3" style="margin-bottom:20px;">'+
                    '<img style="width:100%;" src="'+baseUrlApi+'/writable/uploads/'+dt_docs_upload_image[i].name+'" title="" />'+
                '</div>'
                ; 
            }
            if(html_docs_image){
                $(".alert-info-docs-image").css("display","none");
                $("#details-dt-docs-image").html(html_docs_image);
                $("#details-dt-docs-file").html("<ul style='overflow:auto;'><li><a href='"+baseUrlApi+"/writable/uploads/"+dt_docs_upload_file.name+"'>"+dt_docs_upload_file.name+"</a></li></ul>");
                $(".alert-info-docs-file").css("display","none");
            }else{
                $(".alert-info-docs-image").css("display","block");
                $("#details-dt-docs-image").html('');
                $("#details-dt-docs-file").html('');
                $(".alert-info-docs-file").css("display","block");
            }
            
            $("#key_details_docs").val(key);   
            /*$("#form_edit_date_interview").val(date_interview);*/
            /*$("#approvalFormEditMc").html(

                );*/
            $('#DetailsDocumentsVisitor').modal('show');
        });

        $('#dataTable').on('click', 'tbody tr .details-interview-visitor', function (e) { 
            $("#details-question-answers").html('');
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');

            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            var date_interview = $('#dataTable').DataTable().rows( $(this) ).data()[0].interview_date;
            var mc_lead = $('#dataTable').DataTable().rows( $(this) ).data()[0].mc_lead;
            var data_result_interview = $('#dataTable').DataTable().rows( $(this) ).data()[0].id_interview.data_result_interview.reverse();
            var mc_attendance = JSON.parse($('#dataTable').DataTable().rows( $(this) ).data()[0].mc_attendance);
            var name_vp_attendance = $('#dataTable').DataTable().rows( $(this) ).data()[0].name_vp_attendance;
            var vp_attendance = $('#dataTable').DataTable().rows( $(this) ).data()[0].vp_attendance == 1 ? 'Attendance' : 'Not Attendance';
            var background_history = $('#dataTable').DataTable().rows( $(this) ).data()[0].background_history;
            var stringArray = new Array();
            for(var i =0; i < mc_attendance.length; i++){
                stringArray.push(mc_attendance[i].trim());
            }


             html_docs_image = '';
             var html_result_interview = '';
            //dt_docs_upload_image.forEach(viewHtmlDetailsDocsImage);
            for (var i = 0; i < data_result_interview.length; i++) {
                        var answers_option = '';
                        if(data_result_interview[i].answers_option==1){
                            answers_option = "YES";
                        }else if(data_result_interview[i].answers_option==2){
                            answers_option = "NO";
                        }
                        if(answers_option){
                            var answers_option = '<p style="width: 50px;background-color: #008e10;padding: 5px 10px;text-align: center;color: #fff;">'+answers_option+'</p>';
                        }else{
                            var answers_option = '';
                        }
                        html_result_interview += '<div style="border-top:1px solid #cecece; border-left:1px solid #cecece; border-right:1px solid #cecece; padding:20px;">'+
                                                    '<div class="row">'+
                                                        '<div class="col-md-12">'+
                                                            data_result_interview[i].question+
                                                            '<hr>'+
                                                            answers_option+
                                                            '<p style="font-weight:bold;">Note :</p>'+
                                                            '<p>'+data_result_interview[i].answers_note+'</p>'+
                                                        '</div>'+
                                                    '</div>'+
                                                '</div>'; 
            }

    

            //data_result_interview.forEach(viewHtmlResultInterview);

            let last_mc_attendance = stringArray.pop();
            let mc_attendance_result = stringArray.join(', ')+' and '+last_mc_attendance;
           
            $("#key_details_docs").val(key);
            $("#date_interview_result").html(moment(date_interview).format('YYYY-MM-DD'));
            $("#mc_lead_result").html(mc_lead); 
            $("#mc_attendance_result").html(mc_attendance_result);
            $("#name_vp_attendance").html(name_vp_attendance+' <span style="color:#cecece;">( '+vp_attendance+' )</span>')
            $("#details-question-answers").html(html_result_interview);
            $("#background_history").html(background_history);
            $('#DetailInterviewResultsVisitor').modal('show');
        });

        
    }else{

        /*proses visitor menu VH*/
        $('#dataTable').on('click', 'tbody tr .approval_edit', function (e) {    
        //fnResetControls();    
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');
            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            const status_visitor = $('#dataTable').DataTable().rows( $(this) ).data()[0].status_visitor;
            $("#key").val(key);     
            $("#approvalVh").val(status_visitor).attr('selected', 'selected');
            $('#editStatusVisitorVH').modal('show');
        });

        $('#dataTable').on('click', 'tbody tr .editor-edit-vh', function (e) {    
        //fnResetControls();    

            //console.log($('#dataTable').DataTable().rows( $(this) ).data());
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');

            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            const date_visit = $('#dataTable').DataTable().rows( $(this) ).data()[0].date_visit;
            const name_visitor = $('#dataTable').DataTable().rows( $(this) ).data()[0].name_visitor;
            const number_contact = $('#dataTable').DataTable().rows( $(this) ).data()[0].number_contact;
            const bussines_description = $('#dataTable').DataTable().rows( $(this) ).data()[0].bussines_description;
            const name_sponsor = $('#dataTable').DataTable().rows( $(this) ).data()[0].name_sponsor;

            $("#key2").val(key);   
            $("#date_visit").val(date_visit);
            $("#name_visitor").val(name_visitor);
            $("#number_contact").val(number_contact);
            $("#bussines_description").val(bussines_description);
            $("#name_sponsor").val(name_sponsor);
            $('#editFormVH').modal('show');
        });

        $('#dataTable').on('click', 'tbody tr .editor_remove', function (e) {    
        //fnResetControls();
            //console.log($('#dataTable').DataTable().rows( $(this) ).data());
            var dataTable = $('#dataTable').DataTable();    
            var clickedRow = $($(this).closest('td')).closest('tr');

            const key = $('#dataTable').DataTable().rows( $(this) ).data()[0].id;
            

            $("#key_remove").val(key);  
            $('#removeFormVH').modal('show');
        });

        
    }

    


    function testselect(fieldprop){
        console.log($('select[name='+fieldprop+']').val());
    }
    /*function fnResetControls() {    
        var openedTextBox = $('#dtExample').find('input');    
        $.each(openedTextBox, function (k, $cell) {    
            $(openedTextBox[k]).closest('td').html($cell.value);    
        })    
    }*/
    /*$('#dataTable').on( 'keydown', 'tbody td:not(:first-child) #DTE_Field_interview_mc_note', function (e) {
        console.log(e.keyCode);
        if(e.keyCode == 13 && that.s.displayed) {
            e.preventDefault();
            editor.submit();
        }
    } );*/
/*$('#dataTable').on('click', '.editor_remove .btn-danger', function (e) {
        e.preventDefault();
 
        row = $(this).closest("tr");
 
        editorRemove.remove(row,
            {
                title: 'Delete row',
                message: 'Are you sure you wish to delete this row?',
                buttons: ['Delete', {
                    label: 'Cancel',
                    fn: function () {
                        this.close();
                    }
                }]
            });
    });*/


function submit_approval_status_vh(event){

    // Stop propagation
    //event.preventDefault();
   
    //console.log(imageFile[0]); return false;
    var formData = new FormData();
    
    // These extra params aren't necessary but show that you can include other data.
    formData.append("id", event.key.value);
    formData.append("status_visitor", event.approvalVh.value);
    formData.append("date_approve_vh", moment().format('YYYY-MM-DD H:i:s'));
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            console.log(percentComplete + '% uploaded');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {/*
            console.log(this.response);*/
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#editStatusVisitorVH').modal('hide');
            
        }else{
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}


function submit_form_vh(event){
    //console.log(event); return false;
    // Stop propagation 
    //event.preventDefault();
   
    //console.log(imageFile[0]); return false;
    var formData = new FormData();/*
    $("#key").val(key);   
            $("#date_visit").val(date_visit);
            $("#name_visitor").val(name_visitor);
            $("#number_contact").val(number_contact);
            $("#bussines_description").val(bussines_description);
            $("#name_sponsor").val(name_sponsor);*/
    // These extra params aren't necessary but show that you can include other data.
    formData.append("id", event.key2.value);
    formData.append("date_visit", event.date_visit.value);
    formData.append("name_visitor", event.name_visitor.value);
    formData.append("number_contact", event.number_contact.value);
    formData.append("bussines_description", event.bussines_description.value);
    formData.append("name_sponsor", event.name_sponsor.value);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            console.log(percentComplete + '% uploaded');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {/*
            console.log(this.response);*/
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#editFormVH').modal('hide');
            
        }else{
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}

function submit_form_approve_vh(event){
    var params = $("#key_approval_vh__").val();

    //tableDetailsApprove.draw();
    //var status_visitor = $('#dataTableDetailsApprove').DataTable().rows( $(this) ).data()[0].status_visitor;
    var arr = [];
    var data = tableDetailsApprove.rows().data();
    if(uri_segment=="mc"){
        data.each(function (value, index) {
            arr.push({'uri_segment': uri_segment,'status_visitor':value.status_visitor,'key':btoa(value.id),'date_approve_mc':moment().format('YYYY-MM-DD H:m:s'),'send_mail_mc':1});
        });
    }else if(uri_segment=="st"){
        data.each(function (value, index) {
            arr.push({'uri_segment': uri_segment,'status_visitor':value.status_visitor,'key':btoa(value.id),'date_approve_st':moment().format('YYYY-MM-DD H:m:s'),'send_mail_st':1});
        });
    }else{
        data.each(function (value, index) {
            arr.push({'uri_segment': uri_segment,'status_visitor':value.status_visitor,'key':btoa(value.id),'date_approve_vh':moment().format('YYYY-MM-DD H:m:s'),'send_mail_vh':1});
        });
    }

    //console.log(arr); return false;
    //console.log(data);

    var formData = new FormData();
    
    formData.append("data", JSON.stringify(arr));
    formData.append("option", params);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            console.log(percentComplete + '% uploaded');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {/*
            console.log(this.response);*/
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#dataTableConfirmApprove').modal('hide');
            tableDetailsApprove.clear();
            
        }else{
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}



function remove_form_vh(event){
    var formData = new FormData();
    formData.append("id", event.key_remove.value);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/remove', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            console.log(percentComplete + '% uploaded');
            $( "#submit_remove_vh" ).prop( "disabled", true );
            $("#submit_remove_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {
            //console.log(this.response);
            $( "#submit_remove_vh" ).prop( "disabled", false );
            $("#submit_remove_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#removeFormVH').modal('hide');
            
        }else{
            $( "#submit_remove_vh" ).prop( "disabled", false );
            $("#submit_remove_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}


/*==========function event submit MC ===============*/


function set_date_interview_mc(event){
    var formData = new FormData();
    // These extra params aren't necessary but show that you can include other data.
    //var dateInterview = event.date_interview.value?event.date_interview.value:'NULL';
    formData.append("id", event.key_date_interview.value);
    //formData.append("date_interview", dateInterview);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            console.log(percentComplete + '% uploaded');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {/*
            console.log(this.response);*/
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#SetDateInterviewMC').modal('hide');
            
        }else{
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}

function submit_approval_status_mc(event){
    var formData = new FormData();
    // These extra params aren't necessary but show that you can include other data.
    var approvalMc = event.approvalMc.value?event.approvalMc.value:'NULL';
    //console.log(approvalMc); return false;
    formData.append("id", event.key_approval_mc.value);
    formData.append("approval_mc", approvalMc);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            //console.log(percentComplete + '% uploaded');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {/*
            console.log(this.response);*/
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#editApprovalMC').modal('hide');
            
        }else{
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}

function submit_note_mc(event){
    var formData = new FormData();
    // These extra params aren't necessary but show that you can include other data.
    var note_mc = event.interview_mc_note.value?event.interview_mc_note.value:'';
    //console.log(approvalMc); return false;
    if(note_mc){
        formData.append("id", event.key_note_mc.value);
        formData.append("interview_mc_note", note_mc);
        var xhr = new XMLHttpRequest();
        xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
          
        xhr.upload.onprogress = function(e) {
            if (e.lengthComputable) {
                var percentComplete = (e.loaded / e.total) * 100;
                //console.log(percentComplete + '% uploaded');
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");
                $(".loading-form").css("display","block");
            }
        };

        xhr.onload = function() {
            if (this.status == 200) {/*
                console.log(this.response);*/
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $('#editNoteInterviewMC').modal('hide');
                
            }else{
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
            };
            table.draw();
            tableDetailsApprove.draw();
        };

        xhr.send(formData);
    }else{
        $( "#submit_vh" ).prop( "disabled", false );
        $("#submit_vh").css("cursor", "pointer");
        $(".loading-form").css("display","none");
        /*var resp = JSON.parse(this.response);

        console.log('Server got:', resp);*/
        $('#editNoteInterviewMC').modal('hide');
    }

    
    return false;
    

}

function submit_form_mc(event){
    //console.log(event); return false;
    // Stop propagation 
    //event.preventDefault();
   
    //console.log(imageFile[0]); return false;
    var formData = new FormData();/*
    $("#key").val(key);   
            $("#date_visit").val(date_visit);
            $("#name_visitor").val(name_visitor);
            $("#number_contact").val(number_contact);
            $("#bussines_description").val(bussines_description);
            $("#name_sponsor").val(name_sponsor);*/
    // These extra params aren't necessary but show that you can include other data.
    formData.append("id", event.key_edit_form_mc.value);
    //formData.append("date_interview", event.date_interview.value);
    formData.append("approval_mc", event.approvalMc.value);
    formData.append("interview_mc_note", event.interview_mc_note.value);
    var xhr = new XMLHttpRequest();
    xhr.open('POST', baseUrlApi+'/portal/palms/visitor/update-row', true);
      
    xhr.upload.onprogress = function(e) {
        if (e.lengthComputable) {
            var percentComplete = (e.loaded / e.total) * 100;
            console.log(percentComplete + '% uploaded');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        }
    };

    xhr.onload = function() {
        if (this.status == 200) {/*
            console.log(this.response);*/
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
            /*var resp = JSON.parse(this.response);

            console.log('Server got:', resp);*/
            $('#editFormMC').modal('hide');
            
        }else{
            $( "#submit_vh" ).prop( "disabled", false );
            $("#submit_vh").css("cursor", "pointer");
            $(".loading-form").css("display","none");
        };
        table.draw();
        tableDetailsApprove.draw();
    };

    xhr.send(formData);

    
    return false;
    

}


/*====================================END ==================*/


/*============function table data details to approve ==========*/
function clearDataTableDetailsApprove(event){

    //console.log(event.dataset.close);
    tableDetailsApprove.clear();
}


$(document).ready(function () {
    $("#err_message_import").html('');
    $("#frmdata_import").on('submit', function(e){
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: baseUrlApi+'/portal/palms/visitor/import-data-vh',
            data: new FormData(this),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function(){
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", true );
                $("#submit_vh").css("cursor", "no-drop");
                $(".loading-form").css("display","block");
                /*$('.submitBtn').attr("disabled","disabled");
                $('#fupForm').css("opacity",".5");*/
            },
            success: function(response){
                //var resp = JSON.parse(response);
                //console.log(resp.err_code);
                if(response.err_code==200){
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                            '<strong>'+response.err_message+'!</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                    $( "#submit_vh" ).prop( "disabled", false );
                    $("#submit_vh").css("cursor", "pointer");
                    $(".loading-form").css("display","none");
                    $("#editImportDataVH").modal('hide');
                    document.getElementById("import_visitor").value ='';
                    table.draw(); 
                    tableDetailsApprove.draw(); 
                }else{
                    $("#err_message_import").html('');
                    $( "#submit_vh" ).prop( "disabled", false );
                    $("#submit_vh").css("cursor", "pointer");
                    $(".loading-form").css("display","none");
                    $("#err_message_import").html(
                        '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                            '<strong>General Error or duplicate name visitor!</strong>'+
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                                '<span aria-hidden="true">&times;</span>'+
                            '</button>'+
                        '</div>'
                        );
                }

            }
        });
    });

    // Redraw the table
    table.draw();
    tableDetailsApprove.draw();
    
    // Redraw the table based on the custom input
    $('#searchInput,#sortBy').bind("keyup change", function(){
        table.draw();
        tableDetailsApprove.draw();
    });
    /*$("#daterange").click(function(){
      table.draw();
    });*/

});