$(document).ready(function () {

	var isValid = $("#form-login");
		isValid.validate({
					  	errorClass: "is-invalid",
					  	messages: {
						    password: {
						      	required: "<p style='color:#e74a3b;'>Please enter your password</p>",
						      	minlength: jQuery.validator.format("<p style='color:#e74a3b;'>At least {0} characters required!</p>")
						    
						    },
						    email: {
						      	required: "<p style='color:#e74a3b;'>Please enter your email</p>",
						      	minlength: jQuery.validator.format("<p style='color:#e74a3b;'>At least {0} characters required!</p>")  
						    }
					  	}
					});
	

	$("#form-login").on('submit', function(e){

		
	
		if (isValid.valid()) {
	        e.preventDefault();
	        $.ajax({
	            type: 'POST',
	            url: baseUrlApi+'/login/auth',
	            data: new FormData(this),
	            dataType: 'json',
	            contentType: false,
	            cache: false,
	            processData:false,
	            beforeSend: function(){
	                $("#err_message_import").html('');
	                $( "#submit_login" ).prop( "disabled", true );
	                $("#submit_login").css("cursor", "no-drop");
	                $(".loading-form").css("display","block");
	                /*$('.submitBtn').attr("disabled","disabled");
	                $('#fupForm').css("opacity",".5");*/
	            },
	            success: function(response){
	                //var resp = JSON.parse(response);
	                //console.log(resp.err_code);
	                if(response.err_code==200){
	                    $("#err_message_import").html(
	                        '<div style=" font-size: 12px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
	                            '<strong>'+response.err_message+'!</strong>'+
	                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
	                                '<span aria-hidden="true">&times;</span>'+
	                            '</button>'+
	                        '</div>'
	                        );
	                    $( "#submit_login" ).prop( "disabled", true );
	                    $("#submit_login").css("cursor", "no-drop");
	                    $(".loading-form").css("display","none");
	                    window.setTimeout(function() {
						    window.location.href = baseUrlApi+'/';
						}, 2500);

	                }else{
	                    $("#err_message_import").html('');
	                    $( "#submit_login" ).prop( "disabled", false );
	                    $("#submit_login").css("cursor", "pointer");
	                    $(".loading-form").css("display","none");
	                    $("#err_message_import").html(
	                        '<div style="  font-size: 12px;" class="alert alert-danger alert-dismissible fade show" role="alert">'+
	                            '<strong>'+response.err_message+'!</strong>'+
	                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
	                                '<span aria-hidden="true">&times;</span>'+
	                            '</button>'+
	                        '</div>'
	                        );
	                }

	            }
	        });
	    }
    });
		
});