//
// Pipelining function for DataTables. To be used to the `ajax` option of DataTables
//


//
// DataTables initialisation
//
$('#daterange').daterangepicker({
    autoUpdateInput: false,

    "format": 'Y-m-d H:i:s',
    "startDate": moment().subtract(29, 'days').format('YYYY/MM/DD'),
    "endDate": moment().format('YYYY/MM/DD'),
    "opens": "center",
    "showDropdowns": true,
    locale: {
      format: 'YYYY/MM/DD'
    },
}, function(start, end, label) {
$("#daterange").val(start.format('YYYY/MM/DD')+" - "+end.format('YYYY/MM/DD'));
  table.draw();
  //var this.start_date = start.format('YYYY-MM-DD')?start.format('YYYY-MM-DD'):'sas';
  //console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
});

$('#daterange').on('apply.daterangepicker', function(ev, picker) {
    $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    table.draw();
});

$('#daterange').on('cancel.daterangepicker', function(ev, picker) {
    $(this).val('');
    table.draw();
});


var table = $('#dataTable').DataTable({
  processing: true,
  serverSide: true,
  /*scrollY         : true,
    scrollX         : true,
    scrollCollapse  : true,
    fixedColumns    :   {
        leftColumns     : 1,
        rightColumns    : 2
    },*/
  ajax:{
      method:'POST',
      url: baseUrlApi+'/data/palms/master-menu',
      pages: 5, // number of pages to cache
      data: function ( d ) {
         return $.extend( {}, d, {
           "filter_daterange": $("#daterange").val(),
         } );
       },
      error: function(){  
      },

      
  },

  columns: [
      { data: 'name' },
      { data: 'url' },
      { data: 'user_created' },
      { data: 'date_created' },
      { data: 'status',"width": "10%" },
      { data: null },
      
  ],
  columnDefs: [
        {
            targets: 4,
            render: function (data, type, row) {
                if(data==1){
                    return '<span class="blink-light"><span class="green-light"></span></span> Active';
                }else{
                    return '<span class="blink-light"><span class="red-light"></span></span> Inactive';
                }
            }
        },

        {
            targets: 2,
            render: function (data, type, row) {
                if(data){
                    return row.name_user;
                }else{
                    return '';
                }
            }
        },
        {
            targets: 5,
            render: function (data, type, row) {
                if(data){
                    return '<div class="row" class="button-action">'+
                                '<div class="col-md-6">'+
                                    '<button id="master-menu-edit" class="btn-master-menu btn btn-warning"><i class="fas fa-edit"></i></button>'+
                                '</div>'+
                                '<div class="col-md-6">'+
                                    '<button id="master-menu-remove" class="btn-master-menu btn btn-danger"><i class="fas fa-trash"></i></button>'+
                                '</div>'+
                            '</div>';
                }else{

                }
            }
        }
    ],

   
   /*columnDefs: [{
       targets: 0,
       
       render: function (data, type, row) {
           return "<textarea>"+data+"</textarea>";
       },

   }],*/

});



function AddFormDataMasterMenu(data,url,method='post'){
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $("#err_message_import").html('');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        },
        success: function(response){
            if(response.err_code==200){
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
               
                $("#form-add-master-menu").modal('hide');
                $("input[name=images").val('');
                $("input[name=file_docs]").val('');
                table.draw(); 
            }else{
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>General Error or duplicate name visitor!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }

        }
    });
}


function UpdateFormDataMasterMenu(data,url,method='post'){
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $("#err_message_import").html('');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        },
        success: function(response){
            if(response.err_code==200){
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
               
                $("#form-add-master-menu").modal('hide');
                $("input[name=images").val('');
                $("input[name=file_docs]").val('');
                table.draw(); 
            }else{
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>General Error or duplicate name visitor!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }

        }
    });
}



function RemoveFormDataMasterMenu(data,url,method='post'){
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $("#err_message_import").html('');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        },
        success: function(response){
            if(response.err_code==200){
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
               
                $("#form-remove-master-menu").modal('hide');
                $("input[name=images").val('');
                $("input[name=file_docs]").val('');
                table.draw(); 
            }else{
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>General Error or duplicate name visitor!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }

        }
    });
}







$(document).ready(function () {
	//$("#form-master-menu").on
	
	$( "#form-master-menu" ).on( "click", function() {
        $("input[name=event_process").val('create');
        $("#additional-form").html('<input type="hidden" name="date_created" value="'+moment().format('YYYY/MM/DD HH:mm:ss')+'">');
        $("#formMenuMasterBackdropLabel").html('<i class="fas fa-plus"></i> Add menu master form ');
        $("#additional-form").html('');
        $("#add-master-menu")[0].reset();
        $("#submit_vh").text("Save");
	  	$("#form-add-master-menu").modal('show');
	});


    /*event onclick for edit master menu*/
    $( ".table-responsive" ).on( "click", 'tbody tr td #master-menu-edit', function() {
        let data_row = table.row( $(this).parent().parent().parent() ).data();
        $("input[name=event_process").val('update');
        $("#submit_vh").text("Update");
        $("input[name=name").val(data_row.name);
        $("textarea#menu-master-url").val(data_row.url);
        $("#menu-master-status").val(data_row.status).attr('selected', 'selected');
        $("#additional-form").html(
                    '<input type="hidden" name="date_updated" value="'+moment().format('YYYY/MM/DD HH:mm:ss')+'">'+
                    '<input type="hidden" name="id" value="'+data_row.id+'">'
                    );
        $("#formMenuMasterBackdropLabel").html('<i class="fas fa-edit"></i> Edit menu master form ');
        $("#form-add-master-menu").modal('show');
    });

    /*event onclick for remove master menu*/
    $( ".table-responsive" ).on( "click", 'tbody tr td #master-menu-remove', function() {
        let data_row = table.row( $(this).parent().parent().parent() ).data();
        $("input[name=event_process").val('remove');
        $("#additional-form").html(
                    '<input type="hidden" name="id" value="'+data_row.id+'">'
                    );
      /*  let data_row = table.row( $(this).parent().parent().parent() ).data();
        $("input[name=event_process").val('update');
        $("#submit_vh").text("Update");
        $("input[name=name").val(data_row.name);
        $("textarea#menu-master-url").val(data_row.url);
        $("#menu-master-status").val(data_row.status).attr('selected', 'selected');
        $("#additional-form").html(
                    '<input type="hidden" name="date_updated" value="'+moment().format('YYYY/MM/DD HH:mm:ss')+'">'+
                    '<input type="hidden" name="id" value="'+data_row.id+'">'
                    );
        $("#formMenuMasterBackdropLabel").html('<i class="fas fa-edit"></i> Edit menu master form ');*/
        $("#form-remove-master-menu").modal('show');
    });


    /*event submit for add, update master menu*/
	$( "#add-master-menu" ).on( "submit", function( event ) {
        var event_process = $("input[name=event_process").val();
        
        if(event_process=='create'){
    	  	//event.stopPropagation();
    	  	event.preventDefault();
    	  	var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
    		$.each(data_value, function(i, field) {
    		    values[field.name] = field.value;
    		});
            delete values.event_process;
    	  	AddFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/add');
            return false;
        }else if(event_process=='update'){
            event.preventDefault();
            var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
            $.each(data_value, function(i, field) {
                values[field.name] = field.value;
            });
            delete values.event_process;
            UpdateFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/update');
            return false;
            
        }else if(event_process=='remove'){
            event.preventDefault();
            var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
            $.each(data_value, function(i, field) {
                values[field.name] = field.value;
            });
            delete values.event_process;
            RemoveFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/remove');
            return false;
        }else{
            return false;
        }
	});

    $( "#remove-master-menu" ).on( "submit", function( event ) {
        var event_process = $("input[name=event_process").val();
        
        if(event_process=='remove'){
            event.preventDefault();
            var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
            $.each(data_value, function(i, field) {
                values[field.name] = field.value;
            });
            delete values.event_process;
            RemoveFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/remove');
            return false;
        }else{
            return false;
        }
    });

 


    

    /**/
	
    // Redraw the table
    table.draw();
    
    // Redraw the table based on the custom input
    $('#searchInput,#sortBy').bind("keyup change", function(){
        table.draw();
    });
    /*$("#daterange").click(function(){
      table.draw();
    });*/

});