//
// Pipelining function for DataTables. To be used to the `ajax` option of DataTables
//


//
// DataTables initialisation
//
$('#daterange').daterangepicker({
    autoUpdateInput: false,
    "format": 'Y-m-d H:i:s',
    "startDate": moment().subtract(29, 'days').format('YYYY/MM/DD'),
    "endDate": moment().format('YYYY/MM/DD'),
    "opens": "center",
    "showDropdowns": true,
    locale: {
      format: 'YYYY/MM/DD'
    },
}, function(start, end, label) {
$("#daterange").val(start.format('YYYY/MM/DD')+" - "+end.format('YYYY/MM/DD'));
  table.draw();
  //var this.start_date = start.format('YYYY-MM-DD')?start.format('YYYY-MM-DD'):'sas';
  //console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
});
$('#daterange').on('apply.daterangepicker', function(ev, picker) {
    $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    table.draw();
});

$('#daterange').on('cancel.daterangepicker', function(ev, picker) {
    $(this).val('');
    table.draw();
});

var table = $('#dataTable').DataTable({
  processing: true,
  serverSide: true,
  /*scrollY         : true,
    scrollX         : true,
    scrollCollapse  : true,
    fixedColumns    :   {
        leftColumns     : 1,
        rightColumns    : 2
    },*/
  ajax:{
      method:'POST',
      url: baseUrlApi+'/data/palms/menu',
      pages: 5, // number of pages to cache
      data: function ( d ) {
         return $.extend( {}, d, {
           "filter_daterange": $("#daterange").val(),
         } );
       },
      error: function(){  
      },

      
  },

  columns: [
        { data: 'name_menu_parrent' },
        { data: 'name_menu' },
        { data: 'url' },
        { data: 'name_user' },
        { data: 'date_created' },
        { data: 'status',"width": "10%" },
        { data: null },
      
  ],
  columnDefs: [
        {
            targets: 0,
            render: function (data, type, row) {
                console.log(row.name_menu);
                if(data){
                    return data;
                }else{
                    return row.name_menu;
                }
            }
        },

        {
            targets: 1,
            render: function (data, type, row) {
                if(data){
                    //console.log(row);
                    if(row.name_menu_parrent!=null){
                        return data;
                    }else{
                        return '<i style="color:#cecece;">Null</i>';
                    }
                }else{
                    return '';
                }
                
            }
        },
        {
            targets: 5,
            render: function (data, type, row) {
                if(data==1){
                    return '<span class="blink-light"><span class="green-light"></span></span> Active';
                }else{
                    return '<span class="blink-light"><span class="red-light"></span></span> Inactive';
                }
            }
        },

        {
            targets: 3,
            render: function (data, type, row) {
                if(data){
                    return data;
                }else{
                    return '';
                }
            }
        },
        {
            targets: 6,
            render: function (data, type, row) {
                if(data){
                    return '<div class="row" class="button-action">'+
                                '<div class="col-md-6">'+
                                    '<button id="master-menu-edit" class="btn-master-menu btn btn-warning"><i class="fas fa-edit"></i></button>'+
                                '</div>'+
                                '<div class="col-md-6">'+
                                    '<button id="master-menu-remove" class="btn-master-menu btn btn-danger"><i class="fas fa-trash"></i></button>'+
                                '</div>'+
                            '</div>';
                }else{

                }
            }
        }
    ],

   
   /*columnDefs: [{
       targets: 0,
       
       render: function (data, type, row) {
           return "<textarea>"+data+"</textarea>";
       },

   }],*/

});



var isValid = $("#add-master-menu");
    isValid.validate({
        errorClass: "is-invalid",
        rules:{
            menu:{
                required: true,
            },
            parrent_menu:{
                required: true,
            }
        },
        messages: {
            
            menu: {
                required: "<p style='color:#e74a3b; font-size:16px;'>Field 'Menu' is required</p>",
            },
            parrent_menu:{
                required: "<p style='color:#e74a3b; font-size:16px;'>Field 'Set parrent menu' is required</p>",
            }
        },
        errorPlacement: function(error, element) 
        {
            if ( element.is(":radio") ) 
            {
                error.appendTo( element.parents('#message-radio') );
            }
            else 
            { // This is the default behavior 
                error.insertAfter( element );
            }
         }
    });



function AddFormData(data,url,method='post'){
    //console.log(data); return false;
    //console.log(JSON.stringify(data));
    if(!isValid.valid()){
            //console.log("aweu");
            return false;
        }
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $("#err_message_import").html('');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        },
        success: function(response){
            if(response.err_code==200){
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
               
                $("#form-add-master-menu").modal('hide');
                $("input[name=images").val('');
                $("input[name=file_docs]").val('');
                table.draw(); 
            }else{
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>General Error or duplicate name visitor!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }

        }
    });
}


function UpdateFormDataMasterMenu(data,url,method='post'){
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $("#err_message_import").html('');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        },
        success: function(response){
            if(response.err_code==200){
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
               
                $("#form-add-master-menu").modal('hide');
                $("input[name=images").val('');
                $("input[name=file_docs]").val('');
                table.draw(); 
            }else{
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>General Error or duplicate name visitor!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }

        }
    });
}


function getDataParrentMenu(data=null,url,method='post'){
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $(".loading-form").css("display","block");
        },
        success: function(response){
        	if(response.err_code==200){

                var data_resp = response.data ? JSON.stringify(response.data):1;
            	//console.log(Object.keys(response.data).length);
                localStorage.setItem('data_menu',data_resp);
            	if(Object.keys(response.data.data_menu).length>0){
                    
                    $("#parrent_menu2").css('display', 'block');
                }else{
                    $("#parrent_menu2").css('display', 'none');
                }
           	}
            $(".loading-form").css("display","none");
               
                

        }
    });
}



function RemoveFormDataMasterMenu(data,url,method='post'){
    $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        dataType: 'json',
        contentType: 'application/json',
        cache: false,
        processData:false,
        beforeSend: function(){
            $("#err_message_import").html('');
            $( "#submit_vh" ).prop( "disabled", true );
            $("#submit_vh").css("cursor", "no-drop");
            $(".loading-form").css("display","block");
        },
        success: function(response){
            if(response.err_code==200){
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px;" class="alert alert-success alert-dismissible fade show" role="alert">'+
                        '<strong>'+response.err_message+'!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
               
                $("#form-remove-master-menu").modal('hide');
                $("input[name=images").val('');
                $("input[name=file_docs]").val('');
                table.draw(); 
            }else{
                $("#err_message_import").html('');
                $( "#submit_vh" ).prop( "disabled", false );
                $("#submit_vh").css("cursor", "pointer");
                $(".loading-form").css("display","none");
                $("#err_message_import").html(
                    '<div style="position: fixed; z-index: 999999999; right: 0px; bottom: -14px; " class="alert alert-danger alert-dismissible fade show" role="alert">'+
                        '<strong>General Error or duplicate name visitor!</strong>'+
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">'+
                            '<span aria-hidden="true">&times;</span>'+
                        '</button>'+
                    '</div>'
                    );
            }

        }
    });
}







$(document).ready(function () {

	/*if checked child menu so return option parrent menu if checked parrent menu so don't return option parrent menu*/
	
	$('input[name=parrent_menu]').on( "click", function() {

        var data_parrent_menu = JSON.parse(localStorage.getItem('data_menu'));
        var option_menu_parrent = '<select class="form-control" name="select_parent_menu" id="select-parrent-menu">';
       
        //console.log(data_parrent_menu); return false;
        if(data_parrent_menu.data_menu.length>0){
            //console.log(data_parrent_menu.data_menu[0].name_menu);
            for (var i = 0; i < data_parrent_menu.data_menu.length; i++) {
                option_menu_parrent += '<option value="'+data_parrent_menu.data_menu[i].id+'">'+data_parrent_menu.data_menu[i].name_menu+'</option>';
            }
        }
        option_menu_parrent += "</select>";
        
        var option_menu_master = '<select class="form-control" name="url_menu" id="select-menu-master" >';          
        if(data_parrent_menu.data_menu_master.length>0){
            //console.log(data_parrent_menu.data_menu_master[0].name_menu);
            for (var i = 0; i < data_parrent_menu.data_menu_master.length; i++) {
                option_menu_master += '<option value="'+data_parrent_menu.data_menu_master[i].id+'">'+data_parrent_menu.data_menu_master[i].name+' | '+data_parrent_menu.data_menu_master[i].url+'</option>';
            }
        }
        option_menu_master += '</select>';
        $("#select-parrent-menu").remove();
        $("#select-menu-master").remove();
        //console.log(option_menu_master);
		if($("input[name='parrent_menu']:checked").val()==2){
            $("#parent-menu").css('display', 'block');
            $("#parrent-menu-render").html(option_menu_parrent);
            $( "#parrent-menu-master" ).show();
            $("#menu-master").html(option_menu_master);
		}else if($("input[name='parrent_menu']:checked").val()==1){
			$("#parent-menu").css('display', 'none');
            $( "#parrent-menu-master" ).hide();
            $("#select-parrent-menu").remove();
            $("#select-menu-master").remove();
		}
        
		
	});
	//$("#form-master-menu").on
	
	$( "#form-master-menu" ).on( "click", function() {
        localStorage.clear();
		getDataParrentMenu('', baseUrlApi+'/portal/palms/menu/get-parrent-menu');
		//localStorage.clear('data_menu'); 
		//localStorage.clear('data_menu'); 

        $("input[name=event_process").val('create');
        $("#additional-form").html('<input type="hidden" name="date_created" value="'+moment().format('YYYY/MM/DD HH:mm:ss')+'">');
        $("#formMenuMasterBackdropLabel").html('<i class="fas fa-plus"></i> Add menu form ');
        $("#additional-form").html('');
        $("#add-master-menu")[0].reset();
        $("#submit_vh").text("Save");
	  	$("#form-add-master-menu").modal('show');
	});


    /*event onclick for edit master menu*/
    $( ".table-responsive" ).on( "click", 'tbody tr td #master-menu-edit', function() {
        let data_row = table.row( $(this).parent().parent().parent() ).data();
        $("input[name=event_process").val('update');
        $("#submit_vh").text("Update");
        $("input[name=name").val(data_row.name);
        $("textarea#menu-master-url").val(data_row.url);
        $("#menu-master-status").val(data_row.status).attr('selected', 'selected');
        $("#additional-form").html(
                    '<input type="hidden" name="date_updated" value="'+moment().format('YYYY/MM/DD HH:mm:ss')+'">'+
                    '<input type="hidden" name="id" value="'+data_row.id+'">'
                    );
        $("#formMenuMasterBackdropLabel").html('<i class="fas fa-edit"></i> Edit menu master form ');
        $("#form-add-master-menu").modal('show');
    });

    /*event onclick for remove master menu*/
    $( ".table-responsive" ).on( "click", 'tbody tr td #master-menu-remove', function() {
        let data_row = table.row( $(this).parent().parent().parent() ).data();
        $("input[name=event_process").val('remove');
        $("#additional-form").html(
                    '<input type="hidden" name="id" value="'+data_row.id+'">'
                    );
      /*  let data_row = table.row( $(this).parent().parent().parent() ).data();
        $("input[name=event_process").val('update');
        $("#submit_vh").text("Update");
        $("input[name=name").val(data_row.name);
        $("textarea#menu-master-url").val(data_row.url);
        $("#menu-master-status").val(data_row.status).attr('selected', 'selected');
        $("#additional-form").html(
                    '<input type="hidden" name="date_updated" value="'+moment().format('YYYY/MM/DD HH:mm:ss')+'">'+
                    '<input type="hidden" name="id" value="'+data_row.id+'">'
                    );
        $("#formMenuMasterBackdropLabel").html('<i class="fas fa-edit"></i> Edit menu master form ');*/
        $("#form-remove-master-menu").modal('show');
    });


    /*event submit for add, update master menu*/
	$( "#add-master-menu" ).on( "submit", function( event ) {
        var event_process = $("input[name=event_process").val();
        
        if(event_process=='create'){
    	  	//event.stopPropagation();
    	  	event.preventDefault();
    	  	var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
    		$.each(data_value, function(i, field) {
    		    values[field.name] = field.value;
    		});
            var icons= {'icon':values.icon};
            delete values.event_process;
            delete values.icon;
            //console.log(values); 
    	  	AddFormData(Object.assign(values, icons), baseUrlApi+'/portal/palms/menu/add');
            return false;
        }else if(event_process=='update'){
            event.preventDefault();
            var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
            $.each(data_value, function(i, field) {
                values[field.name] = field.value;
            });
            delete values.event_process;
            UpdateFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/update');
            return false;
            
        }else if(event_process=='remove'){
            event.preventDefault();
            var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
            $.each(data_value, function(i, field) {
                values[field.name] = field.value;
            });
            delete values.event_process;
            RemoveFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/remove');
            return false;
        }else{
            return false;
        }
	});

    $( "#remove-master-menu" ).on( "submit", function( event ) {
        var event_process = $("input[name=event_process").val();
        
        if(event_process=='remove'){
            event.preventDefault();
            var values = {};
            var data_value = $('#add-master-menu').serializeArray();
            
            $.each(data_value, function(i, field) {
                values[field.name] = field.value;
            });
            delete values.event_process;
            RemoveFormDataMasterMenu(values, baseUrlApi+'/portal/palms/master-menu/remove');
            return false;
        }else{
            return false;
        }
    });

 


    

    /**/
	
    // Redraw the table
    //table.draw();
    
    // Redraw the table based on the custom input
    $('#searchInput,#sortBy').bind("keyup change", function(){
        table.draw();
    });
    /*$("#daterange").click(function(){
      table.draw();
    });*/

});